from function_util import parallelize_regions


@parallelize_regions
def flip_pvalues(regional_pvalues):
    """
    To some approximation, convert counts matrices containing left-tail p-values
    to right-tail p-values or vice-versa.

    Parameters
    ----------
    regional_pvalues : np.ndarray
        The counts matrix containing p-values to flip.

    Returns
    -------
    np.ndarray
        The flipped p-values.
    """
    return 1.0 - regional_pvalues