library(MASS)

args <- commandArgs(trailingOnly = TRUE)

files <- Sys.glob(args)

group=read.table(files[1],sep='\t')
group_regions=as.matrix(group$V1)
group_matrix = cbind(group_regions,group[2],group[3])
region = unique(group_matrix$group_regions)
rep_trim1=gsub(".txt*$",'',files[1])

lambdas={}
for (i in 1:length(region)){
    centers<-group_matrix$V2[grep(region[i],group_matrix$group_regions)]
    for (j in 1:length(centers)){
        values <-as.character(group_matrix$V3[grep(region[i],group_matrix$group_regions)][j])
        numeric_values<-as.numeric(unlist(strsplit(values,', ')))
        a = fitdistr(numeric_values[!is.na(numeric_values)],"Poisson")
        lambdas<-append(lambdas,as.numeric(a$estimate[1]))
    }
}
file_name=sprintf("%s_lambdas.txt", rep_trim1)
table=cbind(group_regions,as.matrix(group$V2),lambdas)
write.table(table, file=file_name, sep = "\t",row.names = FALSE, col.names = FALSE, quote = FALSE)

