library(MASS)

args <- commandArgs(trailingOnly = TRUE)

files <- Sys.glob(args)

for (i in 1:length(files)){
  counts=read.table(files[i])
  regions=as.matrix(gsub("_.*$",'',counts$V1))
  counts_region=cbind(regions,counts[3])
  region=unique(counts_region$regions)
  rep_trim1=gsub(".counts*$",'',files[i])
  pvalues={}
  for (j in 1:length(region)){
    total_region<-counts_region$V3[grep(region[j],counts_region$regions)]
    total_region_model<-total_region[!is.na(total_region)]
    a=fitdistr(total_region_model, "logistic")#>0
    
    pvalue<-plogis(total_region,location = as.numeric(a$estimate[1]), scale =as.numeric(a$estimate[2]),lower.tail = FALSE)
    pvalue[total_region=='NaN']='nan'
    pvalues<-append(pvalues,pvalue)
  }
  file_name=sprintf("%s_pvalues.counts", rep_trim1)
  Rep_pvalues=cbind(as.matrix(counts$V1),as.matrix(counts$V2),pvalues)
  write.table(Rep_pvalues, file=file_name, sep = "\t",row.names = FALSE, col.names = FALSE, quote = FALSE)
}
