import numpy as np
from scipy.ndimage.filters import generic_filter
from estimate_moments import estimate_moments
from function_util import parallelize_regions

@parallelize_regions
def donut_moment_estimate(obs_matrix, dist_gen, moment=1, p=5, w=15, log=False,
                          pseudocount=1.0):
    footprint = [[1 if i != w and ((i > p + w or i < w - p) or
                                   (j < w - p or j > p + w)) and j != w
                  else 0
                  for i in xrange(2 * w + 1)] for j in xrange(2 * w + 1)]
    return generic_filter(
        obs_matrix,
        lambda x: estimate_moments(
            x,
            dist_gen,
            log=log,
            pseudocount=pseudocount
        )[moment-1],
        footprint=footprint,
        mode='constant'
    )

