import numpy as np
from propagate_nans import propagate_nans
from function_util import parallelize_regions

@parallelize_regions
def deconvolute(matrix,bias):
    """
    Convenience function that deconvolutes observed data
    given a bias vector

    Parameters
    ----------
    matrix : np.ndarray
        The matrix to deconvolute
    bias : np.ndarray
        The bias vector used to transform the matrix

    Returns
    -------
    np.ndarray
        The deconvoluted matrix
    """
    bias_matrix = np.outer(bias, bias)

    matrix[np.isfinite(matrix)] *= bias_matrix[np.isfinite(matrix)]

    matrix = np.floor(matrix)

    return matrix

