import numpy as np

def classify_2i_interaction_scores(compiled_interaction_scores,background_thresh =
                                -10*np.log2(float(0.75)), \
                                sig_thresh = -10 * np.log2(float(0.2)), \
                                border_constit_thresh = -10 * np.log2(float(0.2)), \
                                constit_thresh = -10 * np.log2(float(0.2)), \
                                difference_thresh = 20):
    """
    Classifies a compiled list of interaction scores as background,
    constitutive, es, npc, 2i or any two way combination of those three replicates.

    Parameters
    ----------
    compiled_interaction_scores : List[List[str]]
        A list of lists containing interaction scores across six replicates for
        all bin-bin pairs.
    sig_thresh : float
        Interaction scores above this threshold have the possibility to 
        be classified
    border_constit_thresh : float
        Forms the bottom of the 'uncertain' constitutive zone. Interaction
        scores below this threshold will not be considered present in the 
        replicate classification of interest.
    constit_thresh : float
        Interaction scores above this threshold are considered present in 
        the replicate classification no matter the score in the other 
        replicate being compared
    difference_thresh : float
        The difference between the replicate interaction scores must be 
        greater than this threshold to be classified as replicate specific

    Returns
    -------
    Dict[str, List[List[str]]]
        The keys are the category name, and the values are lists of lists 
        of the first and second bin IDs of each categorized bin-bin pair.
    """
    ES1_Interaction_Scores=[]
    ES2_Interaction_Scores=[]
    pNPC1_Interaction_Scores=[]
    pNPC2_Interaction_Scores=[]
    ES2i_1_Interaction_Scores=[]
    ES2i_2_Interaction_Scores=[]

    es_only_triloops=[]
    npc_only_triloops=[]
    es2i_only_triloops=[]
    es_npc_triloops=[]
    es_es2i_triloops=[]
    npc_es2i_triloops=[]
    constitutive_triloops=[]
    background_loops=[]

    temp_constitutive=[]
    temp_es_npc=[]
    temp_es_es2i=[]
    temp_npc_es2i=[]
           
    for i in range(len(compiled_interaction_scores)):
        #interaction socres
        ES1_interaction_score = compiled_interaction_scores[i][4]
        ES2_interaction_score = compiled_interaction_scores[i][5]
        pNPC1_interaction_score = compiled_interaction_scores[i][6]
        pNPC2_interaction_score = compiled_interaction_scores[i][7]
        ES2i_1_interaction_score = compiled_interaction_scores[i][8]
        ES2i_2_interaction_score = compiled_interaction_scores[i][9]

    ###START THRESHOLDING SCHEME

        ES1_Interaction_Scores.append(ES1_interaction_score)
        ES2_Interaction_Scores.append(ES2_interaction_score)
        pNPC1_Interaction_Scores.append(pNPC1_interaction_score)
        pNPC2_Interaction_Scores.append(pNPC2_interaction_score)
        ES2i_1_Interaction_Scores.append(ES2i_1_interaction_score)
        ES2i_2_Interaction_Scores.append(ES2i_2_interaction_score)

        if ES1_Interaction_Scores[i] < background_thresh \
        and ES2_Interaction_Scores[i] < background_thresh \
        and pNPC1_Interaction_Scores[i] < background_thresh \
        and pNPC2_Interaction_Scores[i] < background_thresh \
        and (ES2i_1_Interaction_Scores[i] < background_thresh \
        and ES2i_2_Interaction_Scores[i] < background_thresh):

            background_loops.append(compiled_interaction_scores[i])

        elif (ES1_Interaction_Scores[i] >= constit_thresh \
        and ES2_Interaction_Scores[i] >= constit_thresh \
        and pNPC1_Interaction_Scores[i] >= constit_thresh \
        and pNPC2_Interaction_Scores[i] >= constit_thresh \
        and (ES2i_1_Interaction_Scores[i] >= constit_thresh \
        and ES2i_2_Interaction_Scores[i] >= constit_thresh)):

            temp_constitutive.append(compiled_interaction_scores[i])

        elif (ES1_Interaction_Scores[i] >= sig_thresh \
        and ES2_Interaction_Scores[i] >= sig_thresh \
        and pNPC1_Interaction_Scores[i] >= sig_thresh \
        and pNPC2_Interaction_Scores[i] >= sig_thresh \
        and pNPC1_Interaction_Scores[i] >= (ES1_interaction_score-difference_thresh) \
        and pNPC2_Interaction_Scores[i] >= (ES1_interaction_score-difference_thresh) \
        and pNPC1_Interaction_Scores[i] >= (ES2_interaction_score-difference_thresh) \
        and pNPC2_Interaction_Scores[i] >= (ES2_interaction_score-difference_thresh) \
        and (pNPC1_Interaction_Scores[i] <= (ES1_interaction_score+difference_thresh) \
        and pNPC2_Interaction_Scores[i] <= (ES1_interaction_score+difference_thresh) \
        and pNPC1_Interaction_Scores[i] <= (ES2_interaction_score+difference_thresh) \
        and pNPC2_Interaction_Scores[i] <= (ES2_interaction_score+difference_thresh)) \
        and (ES2i_1_Interaction_Scores[i] >= sig_thresh \
        and ES2i_2_Interaction_Scores[i] >= sig_thresh) \
        and (ES1_Interaction_Scores[i] >= (ES2i_1_interaction_score-difference_thresh) \
        and ES2_Interaction_Scores[i] >= (ES2i_1_interaction_score-difference_thresh) \
        and ES1_Interaction_Scores[i] >= (ES2i_2_interaction_score-difference_thresh) \
        and ES2_Interaction_Scores[i] >= (ES2i_2_interaction_score-difference_thresh) \
        and (ES1_Interaction_Scores[i] <= (ES2i_1_interaction_score+difference_thresh) \
        and ES2_Interaction_Scores[i] <= (ES2i_1_interaction_score+difference_thresh) \
        and ES1_Interaction_Scores[i] <= (ES2i_2_interaction_score+difference_thresh) \
        and ES2_Interaction_Scores[i] <= (ES2i_2_interaction_score+difference_thresh))) \
        and ((pNPC1_Interaction_Scores[i] >= (ES2i_1_interaction_score-difference_thresh) \
        and pNPC2_Interaction_Scores[i] >= (ES2i_1_interaction_score-difference_thresh) \
        and pNPC1_Interaction_Scores[i] >= (ES2i_2_interaction_score-difference_thresh)\
        and pNPC2_Interaction_Scores[i] >= (ES2i_2_interaction_score-difference_thresh)\
        and (pNPC1_Interaction_Scores[i] <= (ES2i_1_interaction_score+difference_thresh)\
        and pNPC2_Interaction_Scores[i] <= (ES2i_1_interaction_score+difference_thresh)\
        and pNPC1_Interaction_Scores[i] <= (ES2i_2_interaction_score+difference_thresh)\
        and pNPC2_Interaction_Scores[i] <= (ES2i_2_interaction_score+difference_thresh))))):

            temp_constitutive.append(compiled_interaction_scores[i])

        elif (ES1_Interaction_Scores[i] >= sig_thresh \
        and ES2_Interaction_Scores[i] >= sig_thresh) \
        and ((pNPC1_Interaction_Scores[i] < border_constit_thresh \
        and (pNPC2_Interaction_Scores[i] < border_constit_thresh)) \
        and (pNPC1_Interaction_Scores[i] < (ES1_interaction_score-difference_thresh) \
        and pNPC2_Interaction_Scores[i] < (ES1_interaction_score-difference_thresh) \
        and pNPC1_Interaction_Scores[i] < (ES2_interaction_score-difference_thresh) \
        and pNPC2_Interaction_Scores[i] < (ES2_interaction_score-difference_thresh))) \
        and ((ES2i_1_Interaction_Scores[i] < border_constit_thresh \
        and (ES2i_2_Interaction_Scores[i] < border_constit_thresh)) \
        and (ES2i_1_Interaction_Scores[i] < (ES1_interaction_score-difference_thresh) \
        and ES2i_2_Interaction_Scores[i] < (ES1_interaction_score-difference_thresh) \
        and ES2i_1_Interaction_Scores[i] < (ES2_interaction_score-difference_thresh) \
        and ES2i_2_Interaction_Scores[i] < (ES2_interaction_score-difference_thresh))):

            es_only_triloops.append(compiled_interaction_scores[i])

        elif ((pNPC1_Interaction_Scores[i] >= sig_thresh \
        and pNPC2_Interaction_Scores[i] >= sig_thresh) \
        and ((ES1_Interaction_Scores[i] < border_constit_thresh \
        and (ES2_Interaction_Scores[i] < border_constit_thresh)) \
        and (pNPC1_Interaction_Scores[i] > (ES1_interaction_score+difference_thresh) \
        and pNPC2_Interaction_Scores[i] > (ES1_interaction_score+difference_thresh) \
        and pNPC1_Interaction_Scores[i] > (ES2_interaction_score+difference_thresh) \
        and pNPC2_Interaction_Scores[i] > (ES2_interaction_score+difference_thresh))) \
        and ((ES2i_1_Interaction_Scores[i] < border_constit_thresh \
        and (ES2i_2_Interaction_Scores[i] < border_constit_thresh)) \
        and (ES2i_1_Interaction_Scores[i] < (pNPC1_interaction_score-difference_thresh) \
        and ES2i_2_Interaction_Scores[i] < (pNPC1_interaction_score-difference_thresh) \
        and ES2i_1_Interaction_Scores[i] < (pNPC2_interaction_score-difference_thresh) \
        and ES2i_2_Interaction_Scores[i] < (pNPC2_interaction_score-difference_thresh)))):

            npc_only_triloops.append(compiled_interaction_scores[i])

        elif ((ES2i_1_Interaction_Scores[i] >= sig_thresh \
        and ES2i_2_Interaction_Scores[i] >= sig_thresh) \
        and ((ES1_Interaction_Scores[i] < border_constit_thresh \
        and (ES2_Interaction_Scores[i] < border_constit_thresh)) \
        and (ES2i_1_Interaction_Scores[i] > (ES1_interaction_score+difference_thresh) \
        and ES2i_2_Interaction_Scores[i] > (ES1_interaction_score+difference_thresh) \
        and ES2i_1_Interaction_Scores[i] > (ES2_interaction_score+difference_thresh) \
        and ES2i_2_Interaction_Scores[i] > (ES2_interaction_score+difference_thresh))) \
        and ((pNPC1_Interaction_Scores[i] < border_constit_thresh \
        and (pNPC2_Interaction_Scores[i] < border_constit_thresh)) \
        and (ES2i_1_Interaction_Scores[i] > (pNPC1_interaction_score+difference_thresh) \
        and ES2i_2_Interaction_Scores[i] > (pNPC1_interaction_score+difference_thresh) \
        and ES2i_1_Interaction_Scores[i] > (pNPC2_interaction_score+difference_thresh) \
        and ES2i_2_Interaction_Scores[i] > (pNPC2_interaction_score+difference_thresh)))):

            es2i_only_triloops.append(compiled_interaction_scores[i])

        elif (ES1_Interaction_Scores[i] >= constit_thresh \
        and ES2_Interaction_Scores[i] >= constit_thresh \
        and pNPC1_Interaction_Scores[i] >= constit_thresh \
        and pNPC2_Interaction_Scores[i] >= constit_thresh \
        and (ES2i_1_Interaction_Scores[i] < border_constit_thresh)\
        and (ES2i_2_Interaction_Scores[i] < border_constit_thresh)):

            temp_es_npc.append(compiled_interaction_scores[i])

        elif (ES1_Interaction_Scores[i] >= sig_thresh \
        and ES2_Interaction_Scores[i] >= sig_thresh \
        and pNPC1_Interaction_Scores[i] >= sig_thresh \
        and pNPC2_Interaction_Scores[i] >= sig_thresh \
        and (pNPC1_Interaction_Scores[i] >= (ES1_interaction_score-difference_thresh) \
        and pNPC2_Interaction_Scores[i] >= (ES1_interaction_score-difference_thresh) \
        and pNPC1_Interaction_Scores[i] >= (ES2_interaction_score-difference_thresh) \
        and pNPC2_Interaction_Scores[i] >= (ES2_interaction_score-difference_thresh) \
        and (pNPC1_Interaction_Scores[i] <= (ES1_interaction_score+difference_thresh) \
        and pNPC2_Interaction_Scores[i] <= (ES1_interaction_score+difference_thresh) \
        and pNPC1_Interaction_Scores[i] <= (ES2_interaction_score+difference_thresh) \
        and pNPC2_Interaction_Scores[i] <= (ES2_interaction_score+difference_thresh))) \
        and ((ES2i_1_Interaction_Scores[i] < border_constit_thresh) \
        and (ES2i_2_Interaction_Scores[i] < border_constit_thresh) \
        and (ES2i_1_Interaction_Scores[i] < (ES1_interaction_score-difference_thresh)) \
        and (ES2i_2_Interaction_Scores[i] < (ES1_interaction_score-difference_thresh)) \
        and (ES2i_1_Interaction_Scores[i] < (ES2_interaction_score-difference_thresh)) \
        and (ES2i_2_Interaction_Scores[i] < (ES2_interaction_score-difference_thresh)) \
        and (ES2i_1_Interaction_Scores[i] < (pNPC1_interaction_score-difference_thresh)) \
        and (ES2i_2_Interaction_Scores[i] < (pNPC1_interaction_score-difference_thresh)) \
        and (ES2i_1_Interaction_Scores[i] < (pNPC2_interaction_score-difference_thresh)) \
        and (ES2i_2_Interaction_Scores[i] < (pNPC2_interaction_score-difference_thresh)))):

            temp_es_npc.append(compiled_interaction_scores[i])

        elif (ES1_Interaction_Scores[i] >= constit_thresh \
        and ES2_Interaction_Scores[i] >= constit_thresh \
        and ES2i_1_Interaction_Scores[i] >= constit_thresh \
        and ES2i_2_Interaction_Scores[i] >= constit_thresh \
        and (pNPC1_Interaction_Scores[i] < border_constit_thresh) \
        and (pNPC2_Interaction_Scores[i] < border_constit_thresh)):

            temp_es_es2i.append(compiled_interaction_scores[i])

        elif (ES1_Interaction_Scores[i] >= sig_thresh \
        and ES2_Interaction_Scores[i] >= sig_thresh \
        and ES2i_1_Interaction_Scores[i] >= sig_thresh \
        and ES2i_2_Interaction_Scores[i] >= sig_thresh \
        and (ES2i_1_Interaction_Scores[i] >= (ES1_interaction_score-difference_thresh) \
        and ES2i_2_Interaction_Scores[i] >= (ES1_interaction_score-difference_thresh) \
        and ES2i_1_Interaction_Scores[i] >= (ES2_interaction_score-difference_thresh) \
        and ES2i_2_Interaction_Scores[i] >= (ES2_interaction_score-difference_thresh) \
        and (ES2i_1_Interaction_Scores[i] <= (ES1_interaction_score+difference_thresh) \
        and ES2i_2_Interaction_Scores[i] <= (ES1_interaction_score+difference_thresh) \
        and ES2i_1_Interaction_Scores[i] <= (ES2_interaction_score+difference_thresh) \
        and ES2i_2_Interaction_Scores[i] <= (ES2_interaction_score+difference_thresh))) \
        and ((pNPC1_Interaction_Scores[i] < border_constit_thresh) \
        and (pNPC2_Interaction_Scores[i] < border_constit_thresh) \
        and (pNPC1_Interaction_Scores[i] < (ES1_interaction_score-difference_thresh)) \
        and (pNPC2_Interaction_Scores[i] < (ES1_interaction_score-difference_thresh)) \
        and (pNPC1_Interaction_Scores[i] < (ES2_interaction_score-difference_thresh)) \
        and (pNPC2_Interaction_Scores[i] < (ES2_interaction_score-difference_thresh)) \
        and (pNPC1_Interaction_Scores[i] < (ES2i_1_interaction_score-difference_thresh)) \
        and (pNPC2_Interaction_Scores[i] < (ES2i_1_interaction_score-difference_thresh)) \
        and (pNPC1_Interaction_Scores[i] < (ES2i_2_interaction_score-difference_thresh)) \
        and (pNPC2_Interaction_Scores[i] < (ES2i_2_interaction_score-difference_thresh)))):

            temp_es_es2i.append(compiled_interaction_scores[i])

        elif (pNPC1_Interaction_Scores[i] >= constit_thresh \
        and pNPC2_Interaction_Scores[i] >= constit_thresh \
        and ES2i_1_Interaction_Scores[i] >= constit_thresh \
        and ES2i_2_Interaction_Scores[i] >= constit_thresh \
        and (ES1_Interaction_Scores[i] < border_constit_thresh)\
        and (ES2_Interaction_Scores[i] < border_constit_thresh)):

            temp_npc_es2i.append(compiled_interaction_scores[i])

        elif pNPC1_Interaction_Scores[i] >= sig_thresh \
        and pNPC2_Interaction_Scores[i] >= sig_thresh \
        and ES2i_1_Interaction_Scores[i] >= sig_thresh \
        and ES2i_2_Interaction_Scores[i] >= sig_thresh \
        and (ES2i_1_Interaction_Scores[i] >= (pNPC1_interaction_score-difference_thresh) \
        and ES2i_2_Interaction_Scores[i] >= (pNPC1_interaction_score-difference_thresh) \
        and ES2i_1_Interaction_Scores[i] >= (pNPC2_interaction_score-difference_thresh) \
        and ES2i_2_Interaction_Scores[i] >= (pNPC2_interaction_score-difference_thresh) \
        and (ES2i_1_Interaction_Scores[i] <= (pNPC1_interaction_score+difference_thresh) \
        and ES2i_2_Interaction_Scores[i] <= (pNPC1_interaction_score+difference_thresh) \
        and ES2i_1_Interaction_Scores[i] <= (pNPC2_interaction_score+difference_thresh) \
        and ES2i_2_Interaction_Scores[i] <= (pNPC2_interaction_score+difference_thresh) \
        and ((ES1_Interaction_Scores[i] < border_constit_thresh) \
        and (ES2_Interaction_Scores[i] < border_constit_thresh) \
        and (ES1_Interaction_Scores[i] < (pNPC1_interaction_score-difference_thresh)) \
        and (ES2_Interaction_Scores[i] < (pNPC1_interaction_score-difference_thresh)) \
        and (ES1_Interaction_Scores[i] < (pNPC2_interaction_score-difference_thresh)) \
        and (ES2_Interaction_Scores[i] < (pNPC2_interaction_score-difference_thresh)) \
        and (ES1_Interaction_Scores[i] < (ES2i_1_interaction_score-difference_thresh)) \
        and (ES2_Interaction_Scores[i] < (ES2i_1_interaction_score-difference_thresh)) \
        and (ES1_Interaction_Scores[i] < (ES2i_2_interaction_score-difference_thresh)) \
        and (ES2_Interaction_Scores[i] < (ES2i_2_interaction_score-difference_thresh))))):

            temp_npc_es2i.append(compiled_interaction_scores[i])

    for i in range(len(temp_constitutive)):
        #print temp_constitutive[i]
        if i<(len(temp_constitutive)-1):
            if temp_constitutive[i] != temp_constitutive[i+1]:
                constitutive_triloops.append(temp_constitutive[i])
            elif temp_constitutive[i] == temp_constitutive[i+1]:
                continue
                print temp_constitutive[i], "repeat"
        elif i==(len(temp_constitutive)-1):         
            constitutive_triloops.append(temp_constitutive[i])
    print len(constitutive_triloops), "here is the length of the constitutive triloops"

    for i in range(len(temp_es_npc)):
        #print temp_es_npc[i]
        if i<(len(temp_es_npc)-1):
            if temp_es_npc[i] != temp_es_npc[i+1]:
                es_npc_triloops.append(temp_es_npc[i])
            elif temp_es_npc[i] == temp_es_npc[i+1]:
                continue
                print temp_es_npc[i], "repeat"
        elif i==(len(temp_es_npc)-1):
            es_npc_triloops.append(temp_es_npc[i])
    print len(es_npc_triloops), "here is the length of the es_npc triloops"

    for i in range(len(temp_es_es2i)):
        #print temp_es_es2i[i]
        if i<(len(temp_es_es2i)-1):
            if temp_es_es2i[i] != temp_es_es2i[i+1]:
                es_es2i_triloops.append(temp_es_es2i[i])
            elif temp_es_es2i[i] == temp_es_es2i[i+1]:
                continue
                print temp_es_es2i[i], "repeat"
        elif i==(len(temp_es_es2i)-1):
            es_es2i_triloops.append(temp_es_es2i[i])
    print len(es_es2i_triloops), "here is the length of the es_es2i triloops"

    for i in range(len(temp_npc_es2i)):
        #print temp_npc_es2i[i]
        if i<(len(temp_npc_es2i)-1):
            if temp_npc_es2i[i] != temp_npc_es2i[i+1]:
                npc_es2i_triloops.append(temp_npc_es2i[i])
            elif temp_npc_es2i[i] == temp_npc_es2i[i+1]:
                continue
                print temp_npc_es2i[i], "repeat"
        elif i==(len(temp_npc_es2i)-1):
            npc_es2i_triloops.append(temp_npc_es2i[i])
    print len(npc_es2i_triloops), "here is the length of the npc_es2i triloops"
    print len(es_only_triloops), "here is the length of the es_only_triloops"
    print len(npc_only_triloops), "here is the length of the npc_only_triloops"
    print len(es2i_only_triloops), "here is the length of the es2i_only_triloops"
    print len(background_loops), "here is the length of the background_loops"

    return {
            'background': [loop[1:3] for loop in background_loops],
            'constitutive': [loop[1:3] for loop in constitutive_triloops],
            'es_only': [loop[1:3] for loop in es_only_triloops],
            'npc_only': [loop[1:3] for loop in npc_only_triloops],
            '2i_only': [loop[1:3] for loop in es2i_only_triloops],
            'es_npc': [loop[1:3] for loop in es_npc_triloops],
            'es_2i': [loop[1:3] for loop in es_es2i_triloops],
            'npc_2i': [loop[1:3] for loop in npc_es2i_triloops],
            }

