library(MASS)

args <- commandArgs(trailingOnly = TRUE)

files <- Sys.glob(args)

obs_counts=read.table(files[1])
obs_regions=as.matrix(gsub("_.*$",'',obs_counts$V1))
obs_counts_region=cbind(obs_regions,obs_counts[3])
obs_region=unique(obs_counts_region$obs_regions)
  
donut_counts=read.table(files[2])
donut_regions=as.matrix(gsub("_.*$",'',donut_counts$V1))
donut_counts_region=cbind(donut_regions,donut_counts[3])
donut_region=unique(donut_counts_region$donut_regions)

rep_trim1=gsub(".counts*$",'',files[1])

pvalues={}

    for (j in 1:length(obs_region)){
        total_obs_region<-obs_counts_region$V3[grep(obs_region[j],obs_counts_region$obs_regions)]

        total_donut_region<-donut_counts_region$V3[grep(donut_region[j],donut_counts_region$donut_regions)]

        pvalue<-ppois(q=total_obs_region[!is.na(total_obs_region)],lambda = total_donut_region[!is.na(total_donut_region)], lower.tail = FALSE)
        pvalue[total_obs_region=='NaN']='nan'
        pvalues<-append(pvalues,pvalue)
    }

file_name=sprintf("%s_poisson_pvalues.counts", rep_trim1)
Rep_pvalues=cbind(as.matrix(obs_counts$V1),as.matrix(obs_counts$V2),pvalues)
write.table(Rep_pvalues, file=file_name, sep = "\t",row.names = FALSE, col.names = FALSE, quote = FALSE)

