# -*- coding: utf-8 -*-
"""
Created on Wed Jan 25 17:12:20 2017

@author: Owner
"""
import os

import pdb

import matplotlib as mpl
mpl.use('Agg')
import matplotlib.pyplot as plt
import numpy as np
import scipy.stats as stats

def ORIENTATION_count_near_intersections(loops, annotationmap, CTCF_Forward, CTCF_Reverse, margin=0):
    count_loops_w_NO_CTCF_dict = {}
    loops_w_NO_CTCF_dict = {}
    
    count_loops_w_NO_Consensus_dict = {}
    loops_w_NO_Consensus_dict = {}
    
    count_loops_w_Multiple_Consensus_dict = {}
    loops_w_Multiple_Consensus_dict = {}
    
    count_loops_w_OneSide_CTCF_dict = {}
    loops_w_OneSide_CTCF_dict = {}
    
    count_loops_w_Conflicting_CTCF_dict = {}
    loops_w_Conflicting_CTCF_dict = {}
    
    count_loops_w_Unique_CTCF_dict = {}
    
    orientation_intersection_dict = {}
    orientation_intersection_dict['Convergent'] = {}
    orientation_intersection_dict['Divergent'] = {}
    orientation_intersection_dict['Same_Forward'] = {}
    orientation_intersection_dict['Same_Reverse'] = {}
    orientation_intersection_dict['Convergent']['single'] = {}
    orientation_intersection_dict['Convergent']['multiple'] = {}
    orientation_intersection_dict['Convergent']['total'] = {}
    orientation_intersection_dict['Divergent']['single'] = {}
    orientation_intersection_dict['Divergent']['multiple'] = {}
    orientation_intersection_dict['Divergent']['total'] = {}
    orientation_intersection_dict['Same_Forward']['single'] = {}
    orientation_intersection_dict['Same_Forward']['multiple'] = {}
    orientation_intersection_dict['Same_Forward']['total'] = {}
    orientation_intersection_dict['Same_Reverse']['single'] = {}
    orientation_intersection_dict['Same_Reverse']['multiple'] = {}
    orientation_intersection_dict['Same_Reverse']['total'] = {}
    
    count_orientation_intersection_dict = {}
    count_orientation_intersection_dict['Convergent'] = {}
    count_orientation_intersection_dict['Divergent'] = {}
    count_orientation_intersection_dict['Same_Forward'] = {}
    count_orientation_intersection_dict['Same_Reverse'] = {}
    count_orientation_intersection_dict['Convergent']['single'] = {}
    count_orientation_intersection_dict['Convergent']['multiple'] = {}
    count_orientation_intersection_dict['Convergent']['total'] = {}
    count_orientation_intersection_dict['Divergent']['single'] = {}
    count_orientation_intersection_dict['Divergent']['multiple'] = {}
    count_orientation_intersection_dict['Divergent']['total'] = {}
    count_orientation_intersection_dict['Same_Forward']['single'] = {}
    count_orientation_intersection_dict['Same_Forward']['multiple'] = {}
    count_orientation_intersection_dict['Same_Forward']['total'] = {}
    count_orientation_intersection_dict['Same_Reverse']['single'] = {}
    count_orientation_intersection_dict['Same_Reverse']['multiple'] = {}
    count_orientation_intersection_dict['Same_Reverse']['total'] = {}
    
    for loop_type in loops.keys():
        count_loops_w_NO_CTCF_dict[loop_type] = 0
        loops_w_NO_CTCF_dict[loop_type] = {}
        
        count_loops_w_NO_Consensus_dict[loop_type] = 0
        loops_w_NO_Consensus_dict[loop_type] = {}
        
        count_loops_w_Multiple_Consensus_dict[loop_type] = 0
        loops_w_Multiple_Consensus_dict[loop_type] = {}
        
        count_loops_w_OneSide_CTCF_dict[loop_type] = 0
        loops_w_OneSide_CTCF_dict[loop_type] = {}
    
        count_loops_w_Conflicting_CTCF_dict[loop_type] = 0
        loops_w_Conflicting_CTCF_dict[loop_type] = {}
        
        count_loops_w_Unique_CTCF_dict[loop_type] = 0
        
        count_orientation_intersection_dict['Convergent']['single'][loop_type] = 0
        count_orientation_intersection_dict['Convergent']['multiple'][loop_type] = 0
        count_orientation_intersection_dict['Convergent']['total'][loop_type] = 0
        count_orientation_intersection_dict['Divergent']['single'][loop_type] = 0
        count_orientation_intersection_dict['Divergent']['multiple'][loop_type] = 0
        count_orientation_intersection_dict['Divergent']['total'][loop_type] = 0
        count_orientation_intersection_dict['Same_Forward']['single'][loop_type] = 0
        count_orientation_intersection_dict['Same_Forward']['multiple'][loop_type] = 0
        count_orientation_intersection_dict['Same_Forward']['total'][loop_type] = 0
        count_orientation_intersection_dict['Same_Reverse']['single'][loop_type] = 0
        count_orientation_intersection_dict['Same_Reverse']['multiple'][loop_type] = 0
        count_orientation_intersection_dict['Same_Reverse']['total'][loop_type] = 0
        
        orientation_intersection_dict['Convergent']['single'][loop_type] = {}
        orientation_intersection_dict['Convergent']['multiple'][loop_type] = {}
        orientation_intersection_dict['Convergent']['total'][loop_type] = {}
        orientation_intersection_dict['Divergent']['single'][loop_type] = {}
        orientation_intersection_dict['Divergent']['multiple'][loop_type] = {}
        orientation_intersection_dict['Divergent']['total'][loop_type] = {}
        orientation_intersection_dict['Same_Forward']['single'][loop_type] = {}
        orientation_intersection_dict['Same_Forward']['multiple'][loop_type] = {}
        orientation_intersection_dict['Same_Forward']['total'][loop_type] = {}
        orientation_intersection_dict['Same_Reverse']['single'][loop_type] = {}
        orientation_intersection_dict['Same_Reverse']['multiple'][loop_type] = {}
        orientation_intersection_dict['Same_Reverse']['total'][loop_type] = {}
        
        dum = 0        
        for region in loops[loop_type].keys():
            for loop in loops[loop_type][region]:
                dum += 1
                #Sum the number of annotations that exist at each bin index in the range of the start of the bin minus the feathering margin up until the start of the following bin plus the feathering margin
                Count_of_Forward_CTCF_on_Upstream_Side = sum([annotationmap[CTCF_Forward][region][index] for index in range(max(0, loop['y']-margin), min(len(annotationmap[CTCF_Forward][region]), loop['y']+margin+1))])
                Count_of_Forward_CTCF_on_Downstream_Side = sum([annotationmap[CTCF_Forward][region][index] for index in range(max(0, loop['x']-margin), min(len(annotationmap[CTCF_Forward][region]), loop['x']+margin+1))])
                Count_of_Reverse_CTCF_on_Upstream_Side = sum([annotationmap[CTCF_Reverse][region][index] for index in range(max(0, loop['y']-margin), min(len(annotationmap[CTCF_Reverse][region]), loop['y']+margin+1))])
                Count_of_Reverse_CTCF_on_Downstream_Side = sum([annotationmap[CTCF_Reverse][region][index] for index in range(max(0, loop['x']-margin), min(len(annotationmap[CTCF_Reverse][region]), loop['x']+margin+1))])

                Count_of_No_Consensus_CTCF_on_Upstream_Side = sum([annotationmap['Merged_CTCF_NoConsensus'][region][index] for index in range(max(0, loop['y']-margin), min(len(annotationmap['Merged_CTCF_NoConsensus'][region]), loop['y']+margin+1))])
                Count_of_No_Consensus_CTCF_on_Downstream_Side = sum([annotationmap['Merged_CTCF_NoConsensus'][region][index] for index in range(max(0, loop['x']-margin), min(len(annotationmap['Merged_CTCF_NoConsensus'][region]), loop['x']+margin+1))])
                Count_of_Multiple_Consensus_CTCF_on_Upstream_Side = sum([annotationmap['Merged_CTCF_Multiple_Consensus'][region][index] for index in range(max(0, loop['y']-margin), min(len(annotationmap['Merged_CTCF_Multiple_Consensus'][region]), loop['y']+margin+1))])
                Count_of_Multiple_Consensus_CTCF_on_Downstream_Side = sum([annotationmap['Merged_CTCF_Multiple_Consensus'][region][index] for index in range(max(0, loop['x']-margin), min(len(annotationmap['Merged_CTCF_Multiple_Consensus'][region]), loop['x']+margin+1))])
                
                #Count and record the loops that have no CTCF with a single consensus on either side        
                if Count_of_Forward_CTCF_on_Upstream_Side == 0 and Count_of_Forward_CTCF_on_Downstream_Side == 0 and Count_of_Reverse_CTCF_on_Upstream_Side == 0 and Count_of_Reverse_CTCF_on_Downstream_Side == 0:
                    if Count_of_Multiple_Consensus_CTCF_on_Upstream_Side > 0 or Count_of_Multiple_Consensus_CTCF_on_Downstream_Side > 0:
                        count_loops_w_Multiple_Consensus_dict[loop_type] += 1
                        loops_w_Multiple_Consensus_dict[loop_type][loop_type+'_'+str(dum)] = loop
                    elif Count_of_No_Consensus_CTCF_on_Upstream_Side > 0 or Count_of_No_Consensus_CTCF_on_Downstream_Side > 0:
                        count_loops_w_NO_Consensus_dict[loop_type] += 1
                        loops_w_NO_Consensus_dict[loop_type][loop_type+'_'+str(dum)] = loop
                    else:    
                        count_loops_w_NO_CTCF_dict[loop_type] += 1
                        loops_w_NO_CTCF_dict[loop_type][loop_type+'_'+str(dum)] = loop
                    continue
                
                elif (Count_of_Forward_CTCF_on_Upstream_Side == 0 and Count_of_Reverse_CTCF_on_Upstream_Side == 0) or (Count_of_Forward_CTCF_on_Downstream_Side == 0 and Count_of_Reverse_CTCF_on_Downstream_Side == 0):
                    count_loops_w_OneSide_CTCF_dict[loop_type] += 1
                    loops_w_OneSide_CTCF_dict[loop_type][loop_type+'_'+str(dum)] = loop
                    continue
                
                elif (Count_of_Forward_CTCF_on_Upstream_Side > 0 and Count_of_Reverse_CTCF_on_Upstream_Side > 0) or (Count_of_Forward_CTCF_on_Downstream_Side > 0 and Count_of_Reverse_CTCF_on_Downstream_Side > 0):
                    count_loops_w_Conflicting_CTCF_dict[loop_type] += 1
                    loops_w_Conflicting_CTCF_dict[loop_type][loop_type+'_'+str(dum)] = loop
                    continue
                
                #The rest of the loops should have CTCF with consensus sequences on both side of the loop, and they DO NOT have both forward and reverse oriented CTCF sites on either side                    
                else:
                    count_loops_w_Unique_CTCF_dict[loop_type] += 1
                    #Count the convergent loops with only one CTCF site on both sides
                    if Count_of_Forward_CTCF_on_Upstream_Side == 1 and Count_of_Reverse_CTCF_on_Downstream_Side == 1:
                        count_orientation_intersection_dict['Convergent']['single'][loop_type] += 1
                        count_orientation_intersection_dict['Convergent']['total'][loop_type] += 1
                        orientation_intersection_dict['Convergent']['single'][loop_type][loop_type+'_'+str(dum)] = loop
                        orientation_intersection_dict['Convergent']['total'][loop_type][loop_type+'_'+str(dum)] = loop
                        continue
                    
                    #Count the convergent loops with multiple CTCF sites on at least one side
                    elif Count_of_Forward_CTCF_on_Upstream_Side >= 1 and Count_of_Reverse_CTCF_on_Downstream_Side >= 1:
                        count_orientation_intersection_dict['Convergent']['multiple'][loop_type] += 1
                        count_orientation_intersection_dict['Convergent']['total'][loop_type] += 1
                        orientation_intersection_dict['Convergent']['multiple'][loop_type][loop_type+'_'+str(dum)] = loop
                        orientation_intersection_dict['Convergent']['total'][loop_type][loop_type+'_'+str(dum)] = loop
                        continue
                    
                    #Count the divergent loops with only one CTCF site on both sides
                    elif Count_of_Forward_CTCF_on_Downstream_Side == 1 and Count_of_Reverse_CTCF_on_Upstream_Side == 1:
                        count_orientation_intersection_dict['Divergent']['single'][loop_type] += 1
                        count_orientation_intersection_dict['Divergent']['total'][loop_type] += 1
                        orientation_intersection_dict['Divergent']['single'][loop_type][loop_type+'_'+str(dum)] = loop
                        orientation_intersection_dict['Divergent']['total'][loop_type][loop_type+'_'+str(dum)] = loop
                        continue
                    
                    #Count the divergent loops with multiple CTCF sites on at least one side
                    elif Count_of_Forward_CTCF_on_Downstream_Side >= 1 and Count_of_Reverse_CTCF_on_Upstream_Side >= 1:
                        count_orientation_intersection_dict['Divergent']['multiple'][loop_type] += 1
                        count_orientation_intersection_dict['Divergent']['total'][loop_type] += 1
                        orientation_intersection_dict['Divergent']['multiple'][loop_type][loop_type+'_'+str(dum)] = loop
                        orientation_intersection_dict['Divergent']['total'][loop_type][loop_type+'_'+str(dum)] = loop
                        continue
                    
                    #Count the same_forward loops with only one CTCF site on both sides
                    elif Count_of_Forward_CTCF_on_Upstream_Side == 1 and Count_of_Forward_CTCF_on_Downstream_Side == 1:
                        count_orientation_intersection_dict['Same_Forward']['single'][loop_type] += 1
                        count_orientation_intersection_dict['Same_Forward']['total'][loop_type] += 1
                        orientation_intersection_dict['Same_Forward']['single'][loop_type][loop_type+'_'+str(dum)] = loop
                        orientation_intersection_dict['Same_Forward']['total'][loop_type][loop_type+'_'+str(dum)] = loop
                        continue
                    
                    #Count the 'Same_Forward' loops with multiple CTCF sites on at least one side
                    elif Count_of_Forward_CTCF_on_Upstream_Side >= 1 and Count_of_Forward_CTCF_on_Downstream_Side >= 1:
                        count_orientation_intersection_dict['Same_Forward']['multiple'][loop_type] += 1
                        count_orientation_intersection_dict['Same_Forward']['total'][loop_type] += 1
                        orientation_intersection_dict['Same_Forward']['multiple'][loop_type][loop_type+'_'+str(dum)] = loop
                        orientation_intersection_dict['Same_Forward']['total'][loop_type][loop_type+'_'+str(dum)] = loop
                        continue
                    
                    #Count the 'Same_Reverse' loops with only one CTCF site on both sides
                    elif Count_of_Reverse_CTCF_on_Upstream_Side == 1 and Count_of_Reverse_CTCF_on_Downstream_Side == 1:
                        count_orientation_intersection_dict['Same_Reverse']['single'][loop_type] += 1
                        count_orientation_intersection_dict['Same_Reverse']['total'][loop_type] += 1
                        orientation_intersection_dict['Same_Reverse']['single'][loop_type][loop_type+'_'+str(dum)] = loop
                        orientation_intersection_dict['Same_Reverse']['total'][loop_type][loop_type+'_'+str(dum)] = loop
                        continue
                    
                    #Count the 'Same_Forward' loops with multiple CTCF sites on at least one side
                    elif Count_of_Reverse_CTCF_on_Upstream_Side >= 1 and Count_of_Reverse_CTCF_on_Downstream_Side >= 1:
                        count_orientation_intersection_dict['Same_Reverse']['multiple'][loop_type] += 1
                        count_orientation_intersection_dict['Same_Reverse']['total'][loop_type] += 1
                        orientation_intersection_dict['Same_Reverse']['multiple'][loop_type][loop_type+'_'+str(dum)] = loop
                        orientation_intersection_dict['Same_Reverse']['total'][loop_type][loop_type+'_'+str(dum)] = loop
                        continue
                    
                    else:
                        print 'Uh oh! You missed some you dummy!'
                        print Count_of_Forward_CTCF_on_Upstream_Side
                        print Count_of_Forward_CTCF_on_Downstream_Side
                        print Count_of_Reverse_CTCF_on_Upstream_Side
                        print Count_of_Reverse_CTCF_on_Downstream_Side

    return [count_orientation_intersection_dict, orientation_intersection_dict, count_loops_w_Conflicting_CTCF_dict, loops_w_Conflicting_CTCF_dict, count_loops_w_OneSide_CTCF_dict, loops_w_OneSide_CTCF_dict, count_loops_w_NO_CTCF_dict, loops_w_NO_CTCF_dict, count_loops_w_NO_Consensus_dict, loops_w_NO_Consensus_dict, count_loops_w_Multiple_Consensus_dict, loops_w_Multiple_Consensus_dict, count_loops_w_Unique_CTCF_dict]

def compute_p_values(intersection_dict, loops, loop_types):
    p_value_dict = {}
    for orientation in intersection_dict.keys():
        p_value_dict[orientation] = {}
        for loop_type in loop_types:
            p_value_dict[orientation][loop_type] = {}
            one_one = intersection_dict[orientation]['total'][loop_type]
            one_two = intersection_dict[orientation]['total']['background']
            two_one = 0
            two_two = 0         
            print orientation+" Here is the test orientation"
            for orientation1 in intersection_dict.keys(): 
                if orientation1 == orientation:
                    continue
                else:
                    print orientation1+" Here is a complement orientation"
                    print intersection_dict[orientation1]['total'][loop_type]
                    two_one += intersection_dict[orientation1]['total'][loop_type]
                    two_two += intersection_dict[orientation1]['total']['background']
            print two_one
            if one_one == 0 and one_two == 0:
                p_value_dict[orientation][loop_type]['less'] = 0.5
                p_value_dict[orientation][loop_type]['greater'] = 0.5
            else:
                cont_table = [[one_one, one_two], [two_one, two_two]]
                oddsratio, p_l = stats.fisher_exact(cont_table, alternative='less')
                oddsratio, p_g = stats.fisher_exact(cont_table, alternative='greater')
                p_value_dict[orientation][loop_type]['less'] = p_l
                p_value_dict[orientation][loop_type]['greater'] = p_g

    return p_value_dict