library(MASS)
library(ggplot2)


setwd('input/')

args <- commandArgs(trailingOnly = TRUE)

condition=sprintf("*%s.counts", args)
files <- Sys.glob(condition)

for (i in 1:length(files)){
  file=data.frame(read.table(files[i]))
  regions=as.matrix(gsub("_.*$","",file$V1))
  d=cbind(regions,file[3])
  region=levels(d$regions)
  
  for (j in 1:length(region)){
    total_region<-d$V3[grep(region[j],d$regions)]
    total_region_model<-total_region[!is.na(total_region)]
    
    a=fitdistr(total_region_model, "logistic")#>0
    min=min(total_region_model)
    max=max(total_region_model)
    x <- seq(min,max,length=100)
    x1<-dlogis(x, location = as.numeric(a$estimate[1]), scale =as.numeric(a$estimate[2]))
    
    total_region_hist<-hist(total_region,breaks=50,plot=FALSE)
    rep_trim2=gsub("_10_24_2015_16kb_4kb_obs_over_max_donut_ll.counts*$",'',files[i])
    name=sprintf("../output/logistic-%s_%s_%s.jpg", args, rep_trim2,region[j])
    
    jpeg(filename=name, width=5, height=5, units="in", res=500)
    hist(total_region,lty=0,prob=TRUE, xlab='',ylab='',xlim=c(-1.5,1.5),ylim=c(0,1),main='')
    lines(total_region_hist$breaks,c(total_region_hist$density,0),type="s",col=i+1,lwd=1.5)
    
    curve(dlogis(x, location = as.numeric(a$estimate[1]), scale =as.numeric(a$estimate[2])),lwd=2,add=T)
    reps_and_curve=c(rep_trim2,'logistic curve')
    #legend("topright", reps_and_curve, fill=c(i+1,1),cex=0.5)
    dev.off()
  }
}
