import sys
sys.path.insert(0,'../modules2016/stage_1')

import numpy as np
import glob
from generate_primermap import generate_primermap
from load_primer_counts import load_primer_counts
from qnorm_counts_superdict import qnorm_counts_superdict
from write_counts import write_counts

def main():
    # load data
    print('loading data')
    trimmed_primermap = generate_primermap('output/primers_augmented_trimmed.bed')
    counts = glob.glob('output/trimmed_counts/*_trimmed.counts')
    trimmed_counts_superdict ={counts[i].split('/')[2].split('.')[0].split('_trimmed')[0]:
                               load_primer_counts(counts[i],trimmed_primermap)
                               for i in range(len(sorted(counts)))}
    print('quantile normalizing')
    qnormed_counts_superdict = qnorm_counts_superdict(trimmed_counts_superdict,
                                                     trimmed_primermap,regional=True,
                                                     condition_on='% GC')
    # write output
    for rep in trimmed_counts_superdict.keys():
        write_counts(qnormed_counts_superdict[rep],
                     'output/qnormed_counts/%s_conditional_qnormed.counts'%rep,trimmed_primermap)

if __name__ == "__main__":
    main()
