import sys
sys.path.insert(0, '../modules2016')

import numpy as np
from load_pixelmap import load_pixelmap
from load_binned_counts import load_binned_counts
from wipe_short_range_interactions import wipe_short_range_interactions
from write_counts import write_counts

def main():
    # load data
    print('loading data')
    pixelmap = load_pixelmap('output/trimmed_4kb_pixelmap.bed')
    interaction_scores =[#load_binned_counts('output/counts/ScrKD-48Hr-ZC3C1_16kb_4kb_obs_over_exp_int_scores.counts',pixelmap=pixelmap),
                       #load_binned_counts('output/counts/ScrKD-48Hr-ZC3C3_16kb_4kb_obs_over_exp_int_scores.counts',pixelmap=pixelmap),
                       load_binned_counts('output/counts/ScrKD-78Hr-ZC3C1_16kb_4kb_obs_over_exp_int_scores.counts',pixelmap=pixelmap),
                       load_binned_counts('output/counts/ScrKD-78Hr-ZC3C2_16kb_4kb_obs_over_exp_int_scores.counts',pixelmap=pixelmap),
                       #load_binned_counts('output/counts/YY1KD-48Hr-ZC3C1_16kb_4kb_obs_over_exp_int_scores.counts',pixelmap=pixelmap),
                       #load_binned_counts('output/counts/YY1KD-48Hr-ZC3C2_16kb_4kb_obs_over_exp_int_scores.counts',pixelmap=pixelmap),
                       load_binned_counts('output/counts/YY1KD-78Hr-ZC3C1_16kb_4kb_obs_over_exp_int_scores.counts',pixelmap=pixelmap),
                       load_binned_counts('output/counts/YY1KD-78Hr-ZC3C2_16kb_4kb_obs_over_exp_int_scores.counts',pixelmap=pixelmap)]

    reps =                 [#'ScrKD-48Hr-ZC3C1',
                            #'ScrKD-48Hr-ZC3C3',
                            'ScrKD-78Hr-ZC3C1',
                            'ScrKD-78Hr-ZC3C2',
                            #'YY1KD-48Hr-ZC3C1',
                            #'YY1KD-48Hr-ZC3C2',
                            'YY1KD-78Hr-ZC3C1',
                            'YY1KD-78Hr-ZC3C2']

    # trimming diagonal
    print('trimming diagonal')
    diag_trimmed = [[] for i in range(len(interaction_scores))]
    for i in range(len(interaction_scores)):
        diag_trimmed[i],_ = wipe_short_range_interactions(interaction_scores[i],pixelmap,
                                                          distance_span = 'start-to-start')

    # write output
    for i in range(len(diag_trimmed)):
        write_counts(diag_trimmed[i],'output/Fig_7C_Supp_15AC/%s_16kb_4kb_obs_over_exp_int_scores_diag_trimmed.counts'%reps[i],pixelmap)

if __name__ == "__main__":
    main()
