import sys
sys.path.insert(0, '../modules2016')
import json
import numpy as np
from load_pixelmap import load_pixelmap
from load_binned_counts import load_binned_counts
from make_compiled_list_for_2i_thresholding import \
make_compiled_list_for_2i_thresholding
from classify_2i_interaction_scores import \
classify_2i_interaction_scores
from reshape_2i_loops_for_clustering import \
reshape_2i_loops_for_clustering
from make_clusters import make_clusters
from identify_clusters_to_trim import identify_clusters_to_trim
from trim_clusters import trim_clusters
from write_counts import write_counts

def main():
    print('loading data')
    pixelmap = load_pixelmap('output/trimmed_4kb_pixelmap.bed')
    interaction_scores = [load_binned_counts('output/counts/JBR2_ES1_S3_GH_5C_12_11_2015_16kb_4kb_obs_over_exp_int_scores_diag_trimmed.counts'), 
                          load_binned_counts('output/counts/JBR2_ES2_S2_GH_5C_12_11_2015_16kb_4kb_obs_over_exp_int_scores_diag_trimmed.counts'),
                          load_binned_counts('output/counts/pNPC1_S4_10_24_2015_16kb_4kb_obs_over_exp_int_scores_diag_trimmed.counts'),
                          load_binned_counts('output/counts/pNPC2_S3_10_24_2015_16kb_4kb_obs_over_exp_int_scores_diag_trimmed.counts'),
                          load_binned_counts('output/counts/v652i1_S2_10_24_2015_16kb_4kb_obs_over_exp_int_scores_diag_trimmed.counts'),
                          load_binned_counts('output/counts/v652i2_S1_10_24_2015_16kb_4kb_obs_over_exp_int_scores_diag_trimmed.counts')]

    reps = ['JBR2_ES1_S3_GH_5C_12_11_2015','JBR2_ES2_S2_GH_5C_12_11_2015',
            'pNPC1_S4_10_24_2015','pNPC2_S3_10_24_2015','v652i1_S2_10_24_2015',
            'v652i2_S1_10_24_2015']

    print('compiling data')                    
    compiled_interaction_scores =  make_compiled_list_for_2i_thresholding(interaction_scores,pixelmap,
                                                                          distance_span='start-to-start') 
    #classify loops
    print ('classifying loops')
    loops = classify_2i_interaction_scores(compiled_interaction_scores,
                      background_thresh=-10*np.log2(float(0.8)),
                      sig_thresh=-10*np.log2(float(0.165)),
                      border_constit_thresh=-10*np.log2(float(0.0625)),
                      constit_thresh=-10*np.log2(float(0.0625)),
                      difference_thresh=30.2)
    
    # reshape loops for clustering
    print('reshaping loops dict')
    reshaped_loops = reshape_2i_loops_for_clustering(loops,interaction_scores[0].keys())
    
    # make clusters
    print ('making clusters')
    clusters = {category: {region: make_clusters(reshaped_loops[category][region])
                           for region in reshaped_loops[category].keys()}
                for category in reshaped_loops.keys()}

    print('trimming clusters')
    clusters_to_trim = identify_clusters_to_trim(clusters,size_threshold=2)

    cluster_trimmed_interaction_scores = [trim_clusters(interaction_scores[i],
                                                        clusters_to_trim)
                                           for i in range(len(interaction_scores))]

    for i in range(len(cluster_trimmed_interaction_scores)):
        write_counts(cluster_trimmed_interaction_scores[i],
                    'output/counts/%s_16kb_4kb_obs_over_exp_int_scores_diag_cluster_trimmed.counts'%reps[i],pixelmap)


if __name__ == '__main__':
    main()
