import sys
sys.path.insert(0, '../modules2016')

import numpy as np
from copy import deepcopy
from generate_primermap import generate_primermap
from load_primer_counts import load_primer_counts
from remove_primer_primer_pairs import remove_primer_primer_pairs
from write_counts import write_counts

def main():
    # load data
    print('loading data')
    trimmed_primermap = generate_primermap('input/primers_augmented_trimmed.bed')
    joint_express_counts = {#'ScrKD-48Hr-ZC3C1':
                            #load_primer_counts('input/Project018-YY1-Exp1-5C-NPC-ScrKD-48Hr-ZC3C1-JM5C2-S1_S1_merged_counts_JEPCcode_3_23_2016_joint_express.counts',
                            #                   trimmed_primermap),
                            #'ScrKD-48Hr-ZC3C3':
                            #load_primer_counts('input/Project018-YY1-Exp1-5C-NPC-ScrKD-48Hr-ZC3C2-JM5C2-S1_S7_merged_counts_JEPCcode_3_23_2016_joint_express.counts'
                            #                   ,trimmed_primermap),
                            'ScrKD-78Hr-ZC3C1': 
                            load_primer_counts('input/Project018-YY1-Exp1-5C-NPC-ScrKD-78Hr-ZC3C1-JM5C2-S1_S8_merged_counts_JEPCcode_3_23_2016_joint_express.counts',
                                               trimmed_primermap),
                            'ScrKD-78Hr-ZC3C2': 
                            load_primer_counts('input/Project018-YY1-Exp1-5C-NPC-ScrKD-78Hr-ZC3C2-JM5C2-S1_S6_merged_counts_JEPCcode_3_23_2016_joint_express.counts',
                                               trimmed_primermap),
                            #'YY1KD-48Hr-ZC3C1': 
                            #load_primer_counts('input/Project018-YY1-Exp1-5C-NPC-YY1KD-48Hr-ZC3C1-JM5C2-S1_S2_merged_counts_JEPCcode_3_23_2016_joint_express.counts',
                            #                   trimmed_primermap),
                            #'YY1KD-48Hr-ZC3C2':
                            #load_primer_counts('input/Project018-YY1-Exp1-5C-NPC-YY1KD-48Hr-ZC3C2-JM5C2-S1_S5_merged_counts_JEPCcode_3_23_2016_joint_express.counts',
                            #                   trimmed_primermap),
                            'YY1KD-78Hr-ZC3C1':
                            load_primer_counts('input/Project018-YY1-Exp1-5C-NPC-YY1KD-78Hr-ZC3C1-JM5C2-S1_S4_merged_counts_JEPCcode_3_23_2016_joint_express.counts',
                                               trimmed_primermap),
                            'YY1KD-78Hr-ZC3C2': 
			    load_primer_counts('input/Project018-YY1-Exp1-5C-NPC-YY1KD-78Hr-ZC3C2-JM5C2-S1_S3_merged_counts_JEPCcode_3_23_2016_joint_express.counts',
                                                trimmed_primermap)}

    print('removing primer-primer pairs with low counts')
    trimmed_joint_express = remove_primer_primer_pairs(joint_express_counts,trimmed_primermap,
                                                       count_threshold=5,num_reps=3)

    # write output
    for rep in joint_express_counts.keys():
        write_counts(trimmed_joint_express[rep],'intermediates/raw_counts/%s.counts' % rep,
                     trimmed_primermap)

if __name__ == "__main__":
    main()
