import sys
import numpy as np
import glob

def read_settings(settings_fname):
        input = open(settings_fname,'r')
        settings = {}
        for line in input:
                if line[0] == '#':
                        continue
                temp = line.strip().split(' = ')
                settings[temp[0]] = temp[1]
        input.close()
        return settings

def read_bed_file(bedfile):
        input = open(bedfile,'r')
        bins = {}
        bins_list = []
        for line in input:
                if line[0] == '#':
                        continue
                temp = line.strip().split('\t')
		bins[temp[3]] = {}
                bins[temp[3]]['chr'] = temp[0]
                bins[temp[3]]['start'] = temp[1]
                bins[temp[3]]['end'] = temp[2]
		bins[temp[3]]['ID'] = temp[3]
		bins_list.append(temp[3])
        input.close()
        return bins, bins_list

def read_counts_file(countsfile):
        input = open(countsfile,'r')
        interactions = {}
	bin1 = []
	bin2 = []
        for line in input:
                temp = line.strip().split('\t')
                if temp[0] not in interactions.keys():
			interactions[temp[0]] = {}
                interactions[temp[0]][temp[1]] = temp[2]
		bin1.append(temp[0])
		bin2.append(temp[1])
        input.close()
        return interactions, bin1, bin2

#def read_classifications_file(classfile):
#        input = open(classfile,'r')
#        color = []
#        bin1 = []
#        bin2 = []
#        for line in input:
#                temp = line.strip().split('\t')
#                bin1.append(temp[1])
#                bin2.append(temp[2])
#                color.append(temp[0])
#        input.close()
#        return bin1, bin2, color

def make_processed_data_file(bins,bins_list,interactions,countsfiles,bin1,bin2):
        output = open('output/compiled_pvalues.txt','w')
        countsfiles_string = ""
        for i in range(len(countsfiles)):
                countsfiles_string = countsfiles_string+countsfiles[i]+'\t'
                countsfiles_string.strip('\t')
        print >> output, "%s" % ('#Bin1_ID	Bin2_ID		Distance	'+countsfiles_string)      
        for i in range(len(bin1[countsfiles[0]])):
                region = bin1[countsfiles[0]][i].split('_')[0]
		bin1_start = bins[bin1[countsfiles[0]][i]]['start']
                bin1_end = bins[bin1[countsfiles[0]][i]]['end']
                bin2_start = bins[bin2[countsfiles[0]][i]]['start']
                bin2_end = bins[bin2[countsfiles[0]][i]]['end']
		bin1_id = bins[bin1[countsfiles[0]][i]]['ID']
                bin2_id = bins[bin2[countsfiles[0]][i]]['ID']
                distance = int(bin1_start) - int(bin2_start)
                bin_counts = ''
                for k in range(len(countsfiles)):
                        bin_counts = bin_counts + interactions[countsfiles[k]][bin1[countsfiles[0]][i]][bin2[countsfiles[0]][i]]+'\t'
                bin_counts.strip('\t')
                print >> output, "%s\t%s\t%s\t%s\t%s" % (region,bin1_id,bin2_id,distance,bin_counts)


def main():
        #settings = read_settings(sys.argv[1])
        #bins, bins_list = read_bed_file(settings['bedfile'])
        #countsfiles = settings['countsfiles'].split(',')
	bedfile = glob.glob('output/*pixelmap.bed')[0]
        bins, bins_list = read_bed_file(bedfile)
        countsfiles = glob.glob('output/counts/*pvalues.counts')
        interactions = {}
	bin1 = {}
	bin2 = {}
	for i in range(len(countsfiles)):
                interactions[countsfiles[i]], bin1[countsfiles[i]], bin2[countsfiles[i]] = read_counts_file(countsfiles[i])
	make_processed_data_file(bins,bins_list,interactions,countsfiles,bin1,bin2)



if __name__ == '__main__':
        main()
