import sys
sys.path.insert(0, '../modules2016')

import json
from load_pixelmap import load_pixelmap
from make_annotationmaps import make_annotationmaps
from apply_cipher import apply_cipher
from load_binned_counts import load_binned_counts
from reshape_2i_loops_into_matrices import reshape_2i_loops_into_matrices
from plot_annotation_vs_annotation_heatmap import plot_annotation_vs_annotation_heatmap
from plot_looptype_vs_annotation_heatmap import plot_looptype_vs_annotation_heatmap
from plot_stack_bargraph import plot_stack_bargraph
from flatten_counts_single_region_geometric import flatten_counts_single_region

def main():
    # load data
    print('loading data')
    pixelmap = load_pixelmap('output/trimmed_4kb_pixelmap.bed')
    
    annotationmaps = make_annotationmaps(pixelmap,directory='input/annotations/',add_wildcard=True)
    apply_cipher(annotationmaps)

    constant_annotation = 'wildcard'

    counts_dict=load_binned_counts('output/counts/v652i2_S1_10_24_2015_16kb_4kb_obs_over_exp_int_scores_diag_cluster_trimmed.counts',
                      pixelmap=pixelmap)

    with open('output/loops.json') as handle:
        loops = json.load(handle)
    handle.close()

    reshaped_loops = reshape_2i_loops_into_matrices(loops,counts_dict)
    
    del reshaped_loops['gene-desert']
    del pixelmap['gene-desert']   

    # plot heat maps
    annotation_order = ['ES Genes',
                        'ES Enhancers',
                        'Inactive Genes',
                        'Constit Genes',
                        'NPC Genes',
                        'NPC Enhancers',
                        '3 Way Constitutive 1e-8',
                        'ES_2i_notNPC 1e-8',
                        '2i Only 3Way 1e-8',
                        'NPC Only 3Way 1e-8']

    plot_looptype_vs_annotation_heatmap('output/enrichments/Fig4Di.png', constant_annotation,['constitutive'],
                                        annotation_order,annotationmaps,reshaped_loops)

    plot_looptype_vs_annotation_heatmap('output/enrichments/Fig4Dii.png', constant_annotation,['es_2i'], 
                                        annotation_order, annotationmaps,reshaped_loops)

    plot_looptype_vs_annotation_heatmap('output/enrichments/Fig4Diii.png', constant_annotation,['npc_only'], 
                                        annotation_order, annotationmaps,reshaped_loops)

    # change annotation order, keep plotting heat maps

    annotation_order = ['ES Genes',
                        'ES Enhancers',
                        'Inactive Genes',
                        'Constit Genes',
                        'NPC Genes',
                        'NPC Enhancers',
                        'NPC YY1',
                        'ES YY1',
                        '3 Way Constitutive 1e-8',
                        'ES_2i_notNPC 1e-8',
                        '2i Only 3Way 1e-8',
                        'NPC Only 3Way 1e-8']

    plot_looptype_vs_annotation_heatmap('output/enrichments/Fig5D.png', constant_annotation,
                                                 ['npc_only'],annotation_order,annotationmaps,reshaped_loops)

    plot_looptype_vs_annotation_heatmap('output/enrichments/Fig6A.png', constant_annotation,
                                                 ['constitutive'],annotation_order,annotationmaps,reshaped_loops)

    # plot stack barographs
    loop_types = ['2i_only', 'npc_only', 'es_only', 'es_npc', 'es_2i', 'npc_2i', 'constitutive', 'background']
    labels = ['ES_2i only', 'NPC only', 'ES only', 'ES+NPC', 'ES+ES_2i', 'NPC+ES_2i', 'Constitutive', 'Background']

    plot_stack_bargraph('ES_2i_notNPC 1e-8', 'wildcard','output/enrichments/FigS9E.png',loop_types, labels,annotationmaps,reshaped_loops)
    plot_stack_bargraph('ES Enhancers', 'wildcard','output/enrichments/FigS9F.png', loop_types, labels,annotationmaps, reshaped_loops)
    plot_stack_bargraph('ES Genes','wildcard', 'output/enrichments/FigS9G.png', loop_types, labels, annotationmaps, reshaped_loops)
    plot_stack_bargraph('NPC YY1', 'wildcard', 'output/enrichments/Fig10A.png', loop_types, labels, annotationmaps, reshaped_loops)
    plot_stack_bargraph('NPC Enhancers', 'wildcard','output/enrichments/Fig10B.png', loop_types, labels, annotationmaps, reshaped_loops)
    plot_stack_bargraph('NPC Genes', 'wildcard', 'output/enrichments/Fig10B.png', loop_types, labels, annotationmaps, reshaped_loops)
    plot_stack_bargraph('3 Way Constitutive 1e-8', 'wildcard','output/enrichments/FigS11A.png', loop_types, labels,annotationmaps,reshaped_loops)

if __name__ == '__main__':
    main()
