import sys
sys.path.insert(0, '../modules2016')

import numpy as np
from copy import deepcopy
from generate_primermap import generate_primermap
from load_primer_counts import load_primer_counts
from remove_primer_primer_pairs import remove_primer_primer_pairs
from write_counts import write_counts

def main():
    # load data
    print('loading data')
    trimmed_primermap = generate_primermap('input/primers_augmented_trimmed.bed')
    joint_express_counts = {'JBR2_ES1_S3_GH_5C_12_11_2015':
                            load_primer_counts('input/JBR2_ES1_S3_GH_5C_12_11_2015_joint_express.counts',
                                               trimmed_primermap),
                            'JBR2_ES2_S2_GH_5C_12_11_2015':
                            load_primer_counts('input/JBR2_ES2_S2_GH_5C_12_11_2015_joint_express.counts'
                                               ,trimmed_primermap),
                            'pNPC1_S4_10_24_2015': 
                            load_primer_counts('input/pNPC1_S4_10_24_2015_joint_express.counts',
                                               trimmed_primermap),
                            'pNPC2_S3_10_24_2015': 
                            load_primer_counts('input/pNPC2_S3_10_24_2015_joint_express.counts',
                                               trimmed_primermap),
                            'v652i1_S2_10_24_2015': 
                            load_primer_counts('input/v652i1_S2_10_24_2015_joint_express.counts',
                                               trimmed_primermap),
                            'v652i2_S1_10_24_2015': load_primer_counts('input/v652i2_S1_10_24_2015_joint_express.counts',
                                                trimmed_primermap)}

    print('removing primer-primer pairs with low counts')
    trimmed_joint_express = remove_primer_primer_pairs(joint_express_counts,trimmed_primermap,
                                                       count_threshold=10,num_reps=3)

    # write output
    for rep in joint_express_counts.keys():
        write_counts(trimmed_joint_express[rep],'intermediates/raw_counts/%s.counts' % rep,
                     trimmed_primermap)

if __name__ == "__main__":
    main()
