import sys
sys.path.insert(0, '../modules2016')

import numpy as np
from load_pixelmap import load_pixelmap
from load_binned_counts import load_binned_counts
from wipe_short_range_interactions import wipe_short_range_interactions
from write_counts import write_counts

def main():
    # load data
    print('loading data')
    pixelmap = load_pixelmap('output/trimmed_4kb_pixelmap.bed')
    pvalues = [load_binned_counts('output/counts/JBR2_ES1_S3_GH_5C_12_11_2015_16kb_4kb_obs_over_max_donut_ll_pvalues.counts',pixelmap=pixelmap),
                       load_binned_counts('output/counts/JBR2_ES2_S2_GH_5C_12_11_2015_16kb_4kb_obs_over_max_donut_ll_pvalues.counts',pixelmap=pixelmap),
                       load_binned_counts('output/counts/pNPC1_S4_10_24_2015_16kb_4kb_obs_over_max_donut_ll_pvalues.counts',pixelmap=pixelmap),
                       load_binned_counts('output/counts/pNPC2_S3_10_24_2015_16kb_4kb_obs_over_max_donut_ll_pvalues.counts',pixelmap=pixelmap),
                       load_binned_counts('output/counts/v652i1_S2_10_24_2015_16kb_4kb_obs_over_max_donut_ll_pvalues.counts',pixelmap=pixelmap),
                       load_binned_counts('output/counts/v652i2_S1_10_24_2015_16kb_4kb_obs_over_max_donut_ll_pvalues.counts',pixelmap=pixelmap)]

    reps = ['JBR2_ES1_S3_GH_5C_12_11_2015','JBR2_ES2_S2_GH_5C_12_11_2015',
            'pNPC1_S4_10_24_2015','pNPC2_S3_10_24_2015','v652i1_S2_10_24_2015',
            'v652i2_S1_10_24_2015']

    # precompute bin-level expected model
    print('computing interaction scores')
    int_scores = [{region: -10*np.log2(pvalues[i][region]) for region in pvalues[0].keys()} for i in range(len(pvalues))]

    # write output
    for i in range(len(int_scores)):
        write_counts(int_scores[i],'output/counts/%s_16kb_4kb_obs_over_exp_int_scores.counts'%reps[i],pixelmap)

if __name__ == "__main__":
    main()
