import sys
sys.path.insert(0, '../modules2016')

import numpy as np
from load_pixelmap import load_pixelmap
from load_binned_counts import load_binned_counts
from make_expected_matrix_binned import make_expected_matrix_binned
from lowess_empirical_model_bins import lowess_empirical_model_bins
from write_counts import write_counts

def main():
    # load data
    print('loading data')
    pixelmap = load_pixelmap('output/trimmed_4kb_pixelmap.bed')
    observed_counts=[load_binned_counts('output/counts/JBR2_ES1_S3_GH_5C_12_11_2015_16kb_4kb_observed.counts',pixelmap=pixelmap),
                       load_binned_counts('output/counts/JBR2_ES2_S2_GH_5C_12_11_2015_16kb_4kb_observed.counts',pixelmap=pixelmap),
                       load_binned_counts('output/counts/pNPC1_S4_10_24_2015_16kb_4kb_observed.counts',pixelmap=pixelmap),
                       load_binned_counts('output/counts/pNPC2_S3_10_24_2015_16kb_4kb_observed.counts',pixelmap=pixelmap),
                       load_binned_counts('output/counts/v652i1_S2_10_24_2015_16kb_4kb_observed.counts',pixelmap=pixelmap),
                       load_binned_counts('output/counts/v652i2_S1_10_24_2015_16kb_4kb_observed.counts',pixelmap=pixelmap)]

    reps = ['JBR2_ES1_S3_GH_5C_12_11_2015','JBR2_ES2_S2_GH_5C_12_11_2015',
            'pNPC1_S4_10_24_2015','pNPC2_S3_10_24_2015','v652i1_S2_10_24_2015',
            'v652i2_S1_10_24_2015']

    unlogged_observed_counts = [{region: np.exp2(observed_counts[i][region])-1 for region in observed_counts[0].keys()} 
                       for i in range(len(observed_counts))]

    # precompute bin-level expected model
    print('precomputing global expected model')
    expected_counts = [make_expected_matrix_binned(unlogged_observed_counts[i],
                                                   lowess_empirical_model_bins,
                                                   is_global=True,
                                                   logging_function=np.log2,
                                                   exponentiating_function=np.exp2) for i in range(len(observed_counts))]

    logged_expected_counts = [{region: np.log2(expected_counts[i][region]+1) for region in expected_counts[0].keys()}
                              for i in range(len(expected_counts))]

    # write output
    for i in range(len(expected_counts)):
        write_counts(logged_expected_counts[i],'output/counts/%s_16kb_4kb_global_expected.counts'%reps[i],pixelmap)


if __name__ == "__main__":
    main()
