import sys
sys.path.insert(0, '../modules2016')

#from load_primermap import load_primermap
#from load_counts import load_counts
from make_pairwise_correlation_matrix import make_pairwise_correlation_matrix

from load_pixelmap import load_pixelmap
from load_binned_counts import load_binned_counts

def main():
    pixelmap = load_pixelmap('output/trimmed_4kb_pixelmap.bed')

    counts_superdict = {
        'Serum1': load_binned_counts('output/counts/JBR2_ES1_S3_GH_5C_12_11_2015_16kb_4kb_observed.counts', pixelmap=pixelmap),
        'Serum2': load_binned_counts('output/counts/JBR2_ES2_S2_GH_5C_12_11_2015_16kb_4kb_observed.counts', pixelmap=pixelmap),
        'pNPC1': load_binned_counts('output/counts/pNPC1_S4_10_24_2015_16kb_4kb_observed.counts', pixelmap=pixelmap),
        'pNPC2': load_binned_counts('output/counts/pNPC2_S3_10_24_2015_16kb_4kb_observed.counts', pixelmap=pixelmap),
        '2i1': load_binned_counts('output/counts/v652i1_S2_10_24_2015_16kb_4kb_observed.counts', pixelmap=pixelmap),
        '2i2': load_binned_counts('output/counts/v652i2_S1_10_24_2015_16kb_4kb_observed.counts', pixelmap=pixelmap)
    }

    rep_order=['2i1', '2i2', 'Serum1', 'Serum2', 'pNPC1', 'pNPC2']
#    rep_order=['Serum1', 'Serum2']

    spearman_matrix = make_pairwise_correlation_matrix(
        counts_superdict,
        correlation='spearman',
        rep_order=rep_order)
    pearsons_matrix = make_pairwise_correlation_matrix(
        counts_superdict,
        correlation='pearson',
        rep_order=rep_order)

    print rep_order
    print spearman_matrix
    print pearsons_matrix


if __name__=="__main__":
    main()
