from pybedtools import BedTool
import pandas as pd

#Open up all the files as BedTool objects

NPC_enhancers = BedTool('NPC_Enhancer_MTD_160712_Galaxy1314.bed')
NPC_CTCF=BedTool('Project004-IPSHOCH-Exp5-ChIP-NPC-CTCF-IP-Blobel-Rep2-S1_S8_peakcall_MACS2_rendition_1E-8_downsampled_try3_peaks.narrowPeak')
NPC_YY1=BedTool('YY1_NPC_onlymapped_sorted_noduplicates_downsampled_diffuse_pvalue_1E-8_broad_cutoff_1E-4_peaks.bed')

#Parse NPC enhancers into with or without YY1
NPC_enhancers.intersect(NPC_YY1, u=True).saveas('NPC enhancers wYY1.bed')
NPC_enhancers.intersect(NPC_YY1, v=True).saveas('NPC enhancers woYY1.bed')

#For all enhancers that are marked as wo/YY1, if they are within 4000 bp of an enhancers w/YY1, drop that enhancer.
NPC_enhancers_wYY1 = BedTool('NPC enhancers wYY1.bed')
NPC_enhancers_woYY1 = BedTool('NPC enhancers woYY1.bed')
NPC_enhancers_woYY1.closest(NPC_enhancers_wYY1, d=True, t='first').saveas('temp.bed')
NPC_enhancers_woYY1 = pd.read_csv('temp.bed', sep='\t', header=None)
NPC_enhancers_woYY1[NPC_enhancers_woYY1[18]>4000][[0,1,2,3]].to_csv('NPC enhancers woYY1.bed', sep='\t', header=None, index=False)


#Parse NPC enhancers into w/wo CTCF
NPC_enhancers.intersect(NPC_CTCF, u=True).saveas('NPC enhancers wCTCF.bed')
NPC_enhancers.intersect(NPC_CTCF, v=True).saveas('NPC enhancers woCTCF.bed')


#For all enhancers that are marked as wo/CTCF, if they are within 4000 bp of an enhancers w/CTCF, drop that enhancer.
NPC_enhancers_wCTCF = BedTool('NPC enhancers wCTCF.bed')
NPC_enhancers_woCTCF = BedTool('NPC enhancers woCTCF.bed')
NPC_enhancers_woCTCF.closest(NPC_enhancers_wCTCF, d=True,t='first').saveas('temp.bed')
NPC_enhancers_woCTCF = pd.read_csv('temp.bed', sep='\t', header=None)
NPC_enhancers_woCTCF[NPC_enhancers_woCTCF[18]>4000][[0,1,2,3]].to_csv('NPC enhancers woCTCF.bed', sep='\t', header=None, index=False)





#Parse NPC enhancers into wo CTCF and w/woYY1
NPC_enhancers_woCTCF = BedTool('NPC enhancers woCTCF.bed')
NPC_enhancers_woCTCF.intersect(NPC_YY1, u=True).saveas('NPC enhancers woCTCF wYY1.bed')
NPC_enhancers_woCTCF.intersect(NPC_YY1, v=True).saveas('NPC enhancers woCTCF woYY1.bed')

#Parse NPC enhancers into w CTCF and w/woYY1
NPC_enhancers_wCTCF = BedTool('NPC enhancers wCTCF.bed')
NPC_enhancers_wCTCF.intersect(NPC_YY1, u=True).saveas('NPC enhancers wCTCF wYY1.bed')
NPC_enhancers_wCTCF.intersect(NPC_YY1, v=True).saveas('NPC enhancers wCTCF woYY1.bed')

#Make same edit as before with the NPC enhancers and 4000bp thing, woCTCF
NPC_enhancers_woCTCF_woYY1 = BedTool('NPC enhancers woCTCF woYY1.bed')
NPC_enhancers_woCTCF_wYY1 = BedTool('NPC enhancers woCTCF wYY1.bed')
NPC_enhancers_woCTCF_woYY1.closest(NPC_enhancers_woCTCF_wYY1, d=True,t='first').saveas('temp.bed')
NPC_enhancers_woCTCF_woYY1 = pd.read_csv('temp.bed', sep='\t', header=None)
NPC_enhancers_woCTCF_woYY1[NPC_enhancers_woCTCF_woYY1[8]>4000][[0,1,2,3]].to_csv('NPC enhancers woCTCF woYY1.bed', sep='\t', header=None, index=False)


# Make same edit as before with the NPC enhancers and 4000bp thing, wCTCF
NPC_enhancers_wCTCF_woYY1 = BedTool('NPC enhancers wCTCF woYY1.bed')
NPC_enhancers_wCTCF_wYY1 = BedTool('NPC enhancers wCTCF wYY1.bed')
NPC_enhancers_wCTCF_woYY1.closest(NPC_enhancers_wCTCF_wYY1, d=True,t='first').saveas('temp.bed')
NPC_enhancers_wCTCF_woYY1 = pd.read_csv('temp.bed', sep='\t', header=None)
NPC_enhancers_wCTCF_woYY1[NPC_enhancers_wCTCF_woYY1[18]>4000][[0,1,2,3]].to_csv('NPC enhancers wCTCF woYY1.bed', sep='\t', header=None, index=False)
