#This code parses enhancers into w/wo CTCF and w/wo YY1

from pybedtools import BedTool
import pandas as pd

#Open up all the files as BedTool objects

ES_enhancers = BedTool('ES_Enhancer_MTD_160712_Galaxy1311.bed')
ES_CTCF=BedTool('Project004-IPSHOCH-Exp5-ChIP-ES-CTCF-IP-Blobel-Rep2-S1_S2_MACS2_rendition_1E-8_downsampled_try3_peaks.narrowPeak')
ES_YY1=BedTool('mES_Untreated_YY1_batch3_onlymapped_sorted_noduplicates_downsampled_diffuse_pvalue_1E-8_broad_cutoff_1E-4_peaks.broadPeak.bed')

#Parse ES enhancers into with or without YY1
ES_enhancers.intersect(ES_YY1, u=True).saveas('ES enhancers wYY1.bed')
ES_enhancers.intersect(ES_YY1, v=True).saveas('ES enhancers woYY1.bed')

#For all enhancers that are marked as wo/YY1, if they are within 4000 bp of an enhancers w/YY1, drop that enhancer.
ES_enhancers_wYY1 = BedTool('ES enhancers wYY1.bed')
ES_enhancers_woYY1 = BedTool('ES enhancers woYY1.bed')
ES_enhancers_woYY1.closest(ES_enhancers_wYY1, d=True,t='first').saveas('temp.bed')
ES_enhancers_woYY1 = pd.read_csv('temp.bed', sep='\t', header=None)
ES_enhancers_woYY1[ES_enhancers_woYY1[18]>4000][[0,1,2,3]].to_csv('ES enhancers woYY1.bed', sep='\t', header=None, index=False)

#Parse ES enhancers into w/wo CTCF
ES_enhancers.intersect(ES_CTCF, u=True).saveas('ES enhancers wCTCF.bed')
ES_enhancers.intersect(ES_CTCF, v=True).saveas('ES enhancers woCTCF.bed')


#For all enhancers that are marked as wo/CTCF, if they are within 4000 bp of an enhancers w/CTCF, drop that enhancer.
ES_enhancers_wCTCF = BedTool('ES enhancers wCTCF.bed')
ES_enhancers_woCTCF = BedTool('ES enhancers woCTCF.bed')
ES_enhancers_woCTCF.closest(ES_enhancers_wCTCF, d=True,t='first').saveas('temp.bed')
ES_enhancers_woCTCF = pd.read_csv('temp.bed', sep='\t', header=None)
ES_enhancers_woCTCF[ES_enhancers_woCTCF[18]>4000][[0,1,2,3]].to_csv('ES enhancers woCTCF.bed', sep='\t', header=None, index=False)

#Parse ES enhancers into wo CTCF and w/woYY1
ES_enhancers_woCTCF = BedTool('ES enhancers woCTCF.bed')
ES_enhancers_woCTCF.intersect(ES_YY1, u=True).saveas('ES enhancers woCTCF wYY1.bed')
ES_enhancers_woCTCF.intersect(ES_YY1, v=True).saveas('ES enhancers woCTCF woYY1.bed')

#Parse ES enhancers into w CTCF and w/woYY1
ES_enhancers_wCTCF = BedTool('ES enhancers wCTCF.bed')
ES_enhancers_wCTCF.intersect(ES_YY1, u=True).saveas('ES enhancers wCTCF wYY1.bed')
ES_enhancers_wCTCF.intersect(ES_YY1, v=True).saveas('ES enhancers wCTCF woYY1.bed')

#Make same edit as before with the ES enhancers and 4000bp thing, woCTCF
ES_enhancers_woCTCF_woYY1 = BedTool('ES enhancers woCTCF woYY1.bed')
ES_enhancers_woCTCF_wYY1 = BedTool('ES enhancers woCTCF wYY1.bed')
ES_enhancers_woCTCF_woYY1.closest(ES_enhancers_woCTCF_wYY1, d=True,t='first').saveas('temp.bed')
ES_enhancers_woCTCF_woYY1 = pd.read_csv('temp.bed', sep='\t', header=None)
ES_enhancers_woCTCF_woYY1[ES_enhancers_woCTCF_woYY1[8]>4000][[0,1,2,3]].to_csv('ES enhancers woCTCF woYY1.bed', sep='\t', header=None, index=False)


# Make same edit as before with the ES enhancers and 4000bp thing, wCTCF
ES_enhancers_wCTCF_woYY1 = BedTool('ES enhancers wCTCF woYY1.bed')
ES_enhancers_wCTCF_wYY1 = BedTool('ES enhancers wCTCF wYY1.bed')
ES_enhancers_wCTCF_woYY1.closest(ES_enhancers_wCTCF_wYY1, d=True,t='first').saveas('temp.bed')
ES_enhancers_wCTCF_woYY1 = pd.read_csv('temp.bed', sep='\t', header=None)
ES_enhancers_wCTCF_woYY1[ES_enhancers_wCTCF_woYY1[18]>4000][[0,1,2,3]].to_csv('ES enhancers wCTCF woYY1.bed', sep='\t', header=None, index=False)
