import matplotlib as mpl
mpl.use('agg')
import matplotlib.pyplot as plt



import sys
sys.path.insert(0, '../modules2016')

import json
from load_pixelmap import load_pixelmap
from make_annotationmaps import make_annotationmaps
from apply_cipher import apply_cipher
from load_binned_counts import load_binned_counts
from reshape_2i_loops_into_matrices import reshape_2i_loops_into_matrices
from plot_annotation_vs_annotation_heatmap import plot_annotation_vs_annotation_heatmap
from plot_looptype_vs_annotation_heatmap import plot_looptype_vs_annotation_heatmap
from plot_stack_bargraph import plot_stack_bargraph
from flatten_counts_single_region_geometric import flatten_counts_single_region

def main():
    # load data
    print('loading data')
    pixelmap = load_pixelmap('input/trimmed_4kb_pixelmap.bed')

    annotationmaps = make_annotationmaps(pixelmap,directory='input/annotations',add_wildcard=True)
    apply_cipher(annotationmaps)

    #constant_annotation = ['NPC Enhancers w CTCF w YY1', 'NPC Enhancers w CTCF wo YY1', 'NPC Enhancers wo CTCF w YY1', 'NPC Enhancers wo CTCF wo YY1'] 

    counts_dict=load_binned_counts('input/v652i2_S1_10_24_2015_16kb_4kb_obs_over_exp_int_scores_diag_cluster_trimmed.counts',
                      pixelmap=pixelmap)

    with open('input/loops.json') as handle:
        loops = json.load(handle)
    handle.close()

    reshaped_loops = reshape_2i_loops_into_matrices(loops,counts_dict)

    del reshaped_loops['gene-desert']
    del pixelmap['gene-desert']

    annotation_order = ['ES Genes 1_8 Plus Prom','ES Enhancers','NPC Genes 1_8 Plus Prom','NPC Enhancers','Inactive Genes','Constit Genes 1_8 Plus Prom',#'NPC YY1',
    			#'YY1 NPC Only 3Way','yy1 3 Way Constitutive',
                        'CTCF 2i Only 3Way 1e-8','CTCF NPC Only 3Way 1e-8','CTCF 3 Way Constitutive 1e-8','CTCF ES_2i_notNPC 1e-8']
                        #'NPC Enhancers w CTCF w YY1', 'NPC Enhancers w CTCF wo YY1','NPC Enhancers wo CTCF w YY1', 'NPC Enhancers wo CTCF wo YY1']

    plot_looptype_vs_annotation_heatmap('output/es_2i_fig4.png',annotationmaps, reshaped_loops, 'wildcard',
                                                 ['es_2i'],annotation_order,threshold=0,margin=0, vmin=-4.0, vmax=4.0)
    
    plot_looptype_vs_annotation_heatmap('output/npc_only_fig4.png',annotationmaps, reshaped_loops, 'wildcard',
                                                 ['npc_only'],annotation_order,threshold=0,margin=0, vmin=-4.0, vmax=4.0)

    annotation_order = ['ES Genes 1_8 Plus Prom','ES Enhancers','NPC Genes 1_8 Plus Prom','NPC Enhancers','Inactive Genes','Constit Genes 1_8 Plus Prom','NPC YY1',
                        #'YY1 NPC Only 3Way','yy1 3 Way Constitutive',
                        'CTCF 2i Only 3Way 1e-8','CTCF NPC Only 3Way 1e-8','CTCF 3 Way Constitutive 1e-8','CTCF ES_2i_notNPC 1e-8']
                        #'NPC Enhancers w CTCF w YY1', 'NPC Enhancers w CTCF wo YY1','NPC Enhancers wo CTCF w YY1', 'NPC Enhancers wo CTCF wo YY1']

    plot_looptype_vs_annotation_heatmap('output/constit_fig6.png',annotationmaps, reshaped_loops, 'wildcard',
                                                 ['constitutive'],annotation_order,threshold=0,margin=0, vmin=-3.0, vmax=3.0)

    plot_looptype_vs_annotation_heatmap('output/npc_only_fig5.png',annotationmaps, reshaped_loops, 'wildcard',
                                                 ['npc_only'],annotation_order,threshold=0,margin=0, vmin=-4.0, vmax=4.0)

    annotation_order = [
                        'YY1 NPC Only 3Way','yy1 3 Way Constitutive','NPC Enhancers',
                        'NPC Enhancers w CTCF w YY1', 'NPC Enhancers w CTCF wo YY1','NPC Enhancers wo CTCF w YY1']

    plot_looptype_vs_annotation_heatmap('output/npc_only_enhancers_parsed.png',annotationmaps, reshaped_loops, 'wildcard',
                                                 ['npc_only'],annotation_order,threshold=0,margin=0, vmin=-4.0, vmax=4.0)

    annotation_order = [
                        'YY1 NPC Only 3Way','yy1 3 Way Constitutive','NPC Genes 1_8 Plus Prom',
                        'NPC Genes 1_8 Prom w CTCF w YY1', 'NPC Genes 1_8 Prom w CTCF wo YY1', 'NPC Genes 1_8 Prom wo CTCF w YY1']

    plot_looptype_vs_annotation_heatmap('output/npc_only_genes_parsed.png',annotationmaps, reshaped_loops, 'wildcard',
                                                 ['npc_only'],annotation_order,threshold=0,margin=0, vmin=-4.0, vmax=4.0)

    annotation_order = [
                        'YY1 ES Only 3Way','yy1 3 Way Constitutive','ES Enhancers',
                        'ES Enhancers w CTCF w YY1', 'ES Enhancers w CTCF wo YY1','ES Enhancers wo CTCF w YY1']

    plot_looptype_vs_annotation_heatmap('output/es_2i_enhancers_parsed.png',annotationmaps, reshaped_loops, 'wildcard',
                                                 ['es_2i'],annotation_order,threshold=0,margin=0, vmin=-4.0, vmax=4.0)

    annotation_order = [
                        'YY1 ES Only 3Way','yy1 3 Way Constitutive','ES Genes 1_8 Plus Prom',
                        'ES Genes 1_8 Prom w CTCF w YY1', 'ES Genes 1_8 Prom w CTCF wo YY1', 'ES Genes 1_8 Prom wo CTCF w YY1']

    plot_looptype_vs_annotation_heatmap('output/es_2i_genes_parsed.png',annotationmaps, reshaped_loops, 'wildcard',
                                                 ['es_2i'],annotation_order,threshold=0,margin=0, vmin=-4.0, vmax=4.0)

    annotation_order = [
                        'YY1 NPC Only 3Way','yy1 3 Way Constitutive','Constit Genes 1_8 Plus Prom',
                        'Constit Genes 1_8 Prom w CTCF w YY1', 'Constit Genes 1_8 Prom w CTCF wo YY1', 'Constit Genes 1_8 Prom wo CTCF w YY1']

    plot_looptype_vs_annotation_heatmap('output/constit_genes_parsed.png',annotationmaps, reshaped_loops, 'wildcard',
                                                 ['constitutive'],annotation_order,threshold=0,margin=0, vmin=-4.0, vmax=4.0)


if __name__ == '__main__':
    main()
