from __future__ import division
import sys
import pyBigWig
from Fast_pileups_code import pileupplotter
from Fast_pileups_code import process_center_fromfull
from Fast_pileups_code import process_center_frompromgene
from Fast_pileups_code import process_center

def main():
    #NPC_H3K27ac=pyBigWig.open("Group1_Creghyton_NPC_H3K27ac_Phillips_WCE_MACS2_1E-8_downsampled_treat_pileup_sorted_clipped.bw")
    #ES_H3K27ac=pyBigWig.open("Group1_Creghyton_ES_H3K27ac_Creghyton_WCE_MACS2_1E-8_downsampled_treat_pileup_sorted_clipped.bw")

    ES_YY1=pyBigWig.open("input/mES_Untreated_YY1_batch3_onlymapped_sorted_noduplicates_downsampled_treat_pileup_sorted_clipped.bw")
    NPC_YY1=pyBigWig.open("input/YY1_NPC_onlymapped_sorted_noduplicates_downsampled_treat_pileup_sorted_clipped.bw")
    ProB_YY1=pyBigWig.open("input/Pro-B_cell_Yy1_onlymapped_sorted_noduplicates_downsampled_treat_pileup_sorted_clipped.bw")

    ES_enhancers=process_center('input/ES_enhancers.bed', direction=0)
    NPC_enhancers=process_center('input/NPC_enhancers.bed', direction=0)

    NPC_only_YY1 = process_center('input/NPC_only_YY1_Galaxy75-[Subtract_on_data_74_and_data_71].bed', direction=0)
    ES_only_YY1 = process_center('input/ES_only_YY1_Galaxy77-[Subtract_on_data_76_and_data_72].bed', direction=0)
    Constit_YY1=process_center('input/Constit_YY1_Galaxy98-[Merge_on_data_97].bed', direction=0)
    NPC_YY1_Peaks = process_center('input/YY1_NPC_onlymapped_sorted_noduplicates_downsampled_diffuse_pvalue_1E-8_broad_cutoff_1E-4_peaks.bed', direction=0)

    Constit_genes_18_f0_inloops = process_center_frompromgene('input/Constit_Genes_1_8foldUpwAC_in_constit_loops-Galaxy292-[Intersect_on_data_162_and_data_291].bed')
    Constit_genes_18_f0_NOTinloops= process_center_frompromgene('input/Constit_Genes_1_8foldUpwAC_in_NOTin_loops-Galaxy293-[Subtract_on_data_291_and_data_161].bed')
    Constit_genes_18_all = process_center_frompromgene('input/Constit_18_2.14_plusprom.bed')

    ES_genes_18_f0_inloops = process_center_frompromgene('input/ES_genes_1_8_foldup_plusprom_in_es2i_loops-Galaxy253-[Intersect_on_data_175_and_data_250].bed')
    ES_genes_18_all = process_center_frompromgene('input/ES_Genes_1_8foldUpwAC_JB_2_9_17_plus_promotor.bed')
    NPC_genes_18_f0_inloops = process_center_frompromgene('input/NPC_genes_1_8_foldup_plusprom_in_npc_loops-Galaxy266-[Intersect_on_data_176_and_data_265].bed')
    NPC_genes_18_all = process_center_frompromgene('input/NPC_Genes_1_8foldUpwAC_JB_2_9_17_plus_promotor.bed')

    NPC_enhancers_f0_inloops = process_center('input/NPC_enhancers_inloops_full_feather0.bed', direction=0)
    NPC_enhancers_f0_NOTinloops_inBACK=process_center('input/NPC_enhancers_NOTinloops_butINbackground_JB_2_19_17-Galaxy305-[Intersect_on_data_299_and_data_303].bed', direction=0)
    ES_enhancers_f0_NOTinloops_inBACK=process_center('input/ES_enhancers_NOTinloops_butINbackground_JB_2_19_17-Galaxy304-[Intersect_on_data_299_and_data_302].bed', direction=0)
    NPC_genes_18_f0_NOTinloops_inBACK= process_center_frompromgene('input/NPC_genes_1_8_foldup_plusprom_NOTinloops_inBACK-Galaxy300-[Intersect_on_data_299_and_data_268].bed')

    pileupplotter('output/YY1_over_NPC_enhancers_f0_inloops', NPC_enhancers_f0_inloops, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=1.5, averaged=1)
    pileupplotter('output/YY1_over_NPC_enhancers_f0_NOTinloops_inBACK', NPC_enhancers_f0_NOTinloops_inBACK, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=1.5, averaged=1)
    pileupplotter('output/YY1_over_ES_enhancers_f0_NOTinloops_inBACK', ES_enhancers_f0_NOTinloops_inBACK, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=1.5, averaged=1)
    pileupplotter('output/YY1_over_NPC_genes_18_f0_NOTinloops_inBACK', NPC_genes_18_f0_NOTinloops_inBACK, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=4, averaged=1)
    pileupplotter('output/YY1_over_es_genes_18_plusprom_f0_inloops', ES_genes_18_f0_inloops, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=4, averaged=1)
    pileupplotter('output/YY1_over_npc_genes_18_plusprom_f0_inloops', NPC_genes_18_f0_inloops, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=4, averaged=1)
    pileupplotter('output/YY1_over_es_genes_18_plusprom_all', ES_genes_18_all, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=4, averaged=1)
    pileupplotter('output/YY1_over_npc_genes_18_plusprom_all', NPC_genes_18_all, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=4, averaged=1)
    pileupplotter('output/YY1_over_constit_genes_18_plusprom_all', Constit_genes_18_all, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=4, averaged=1)
    pileupplotter('output/YY1_over_constit_genes_18_plusprom_f0_inloops', Constit_genes_18_f0_inloops, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=4, averaged=1)
    pileupplotter('output/YY1_over_constit_genes_18_plusprom_f0_NOTinloops', Constit_genes_18_f0_NOTinloops, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=4, averaged=1)
    pileupplotter('output/YY1_over_ES_enhancers', ES_enhancers, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=1.5, averaged=1)
    pileupplotter('output/YY1_over_NPC_enhancers', NPC_enhancers, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=1.5, averaged=1)    
    pileupplotter('output/YY1_over_NPC_YY1_Peaks', NPC_YY1_Peaks, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=4, averaged=1)
    pileupplotter('output/YY1_over_NPC_only_YY1_average', NPC_only_YY1, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=4, averaged=1)
    pileupplotter('output/YY1_over_ES_only_YY1_average', ES_only_YY1, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=4, averaged=1)
    pileupplotter('output/YY1_over_Constit_YY1_average', Constit_YY1, NPC_YY1, ES_YY1, ProB_YY1, window=1000, bins=100, ylim=4, averaged=1)

if __name__ == "__main__":
    main()



