from __future__ import division
import sys
import pyBigWig
from Fast_pileups_code import pileupplotter
from Fast_pileups_code import process_center_fromfull
from Fast_pileups_code import process_center_frompromgene
from Fast_pileups_code import process_center

def main():
    NPC_CTCF = pyBigWig.open("input/Project004-IPSHOCH-Exp5-ChIP-NPC-CTCF-IP-Blobel-Rep2-S1_S8_peakcall_MACS2_rendition_1E-8_downsampled_try3_treat_pileup_sorted_clipped.bw")
    ES_CTCF = pyBigWig.open("input/Project004-IPSHOCH-Exp5-ChIP-ES-CTCF-IP-Blobel-Rep2-S1_S2_MACS2_rendition_1E-8_downsampled_try3_treat_pileup_sorted_clipped.bw")
    es2i_CTCF = pyBigWig.open("input/Project004-IPSHOCH-Exp5-ChIP-ES-2i-CTCF-IP-Blobel-Rep2-S1_S9_MACS2_rendition_1E-8_downsampled_try3_treat_pileup_sorted_clipped.bw")
  
    NPC_only_YY1 = process_center('input/NPC_only_YY1_Galaxy75-[Subtract_on_data_74_and_data_71].bed', direction=0)
    ES_only_YY1 = process_center('input/ES_only_YY1_Galaxy77-[Subtract_on_data_76_and_data_72].bed', direction=0)
    Constit_YY1=process_center('input/Constit_YY1_Galaxy98-[Merge_on_data_97].bed', direction=0)
    NPC_YY1_Peaks = process_center('input/YY1_NPC_onlymapped_sorted_noduplicates_downsampled_diffuse_pvalue_1E-8_broad_cutoff_1E-4_peaks.bed', direction=0)
   
    NPC_only_CTCF_peaks=process_center('input/NPConly_E-8_E-8_Galaxy490-[Subtract_on_data_489_and_data_36].bed', direction=0)
    Serum_2i_CTCF_peaks=process_center('input/ESand2i_E-8_E-8_Galaxy491-[Subtract_on_data_154_and_data_411].bed', direction=0)
    Constit_CTCF_peaks=process_center('input/Constit_E-8_Galaxy421-[Merged_Concatenate_on_data_418_and_data_417_(as_BED)].bed', direction=0)
    es2i_only_CTCF_peaks=process_center('input/2ionly_E-8_E-8_Galaxy488-[Subtract_on_data_487_and_data_411].bed', direction=0)
    
    NPC_2i_CTCF_peaks=process_center('input/2iandNPC_E-8_E-8_Galaxy493-[Subtract_on_data_439_and_data_35].bed', direction=0)
    Serum_NPC_CTCF_peaks=process_center('input/ESandNPC_E-8_E-8_Galaxy492-[Subtract_on_data_433_and_data_36].bed', direction=0)
    Serum_only_CTCF_peaks=process_center('input/ESonly_E-8_E-8_Galaxy486-[Subtract_on_data_485_and_data_411].bed', direction=0)
    
    pileupplotter('output/CTCF_over_NPC_only_CTCF_average', NPC_only_CTCF_peaks, NPC_CTCF, ES_CTCF, es2i_CTCF, window=1000, bins=100, ylim=6, averaged=1)
    pileupplotter('output/CTCF_over_Serum_2i_CTCF_average', Serum_2i_CTCF_peaks, NPC_CTCF, ES_CTCF, es2i_CTCF, window=1000, bins=100, ylim=6, averaged=1)
    pileupplotter('output/CTCF_over_Constit_CTCF_average', Constit_CTCF_peaks, NPC_CTCF, ES_CTCF, es2i_CTCF, window=1000, bins=100, ylim=6, averaged=1)
    pileupplotter('output/CTCF_over_2i_only_CTCF_average', es2i_only_CTCF_peaks, NPC_CTCF, ES_CTCF, es2i_CTCF, window=1000, bins=100, ylim=6, averaged=1)
    
    pileupplotter('output/CTCF_over_NPC_2i_CTCF_average', NPC_2i_CTCF_peaks, NPC_CTCF, ES_CTCF, es2i_CTCF, window=1000, bins=100, ylim=6, averaged=1)
    pileupplotter('output/CTCF_over_Serum_NPC_CTCF_average', Serum_NPC_CTCF_peaks, NPC_CTCF, ES_CTCF, es2i_CTCF, window=1000, bins=100, ylim=6, averaged=1)
    pileupplotter('output/CTCF_over_Serum_only_CTCF_average', Serum_only_CTCF_peaks, NPC_CTCF, ES_CTCF, es2i_CTCF, window=1000, bins=100, ylim=6, averaged=1)

    pileupplotter('output/CTCF_over_NPC_YY1_Peaks', NPC_YY1_Peaks, NPC_CTCF, ES_CTCF, es2i_CTCF, window=1000, bins=100, ylim=6, averaged=1)
    pileupplotter('output/CTCF_over_NPC_only_YY1_average', NPC_only_YY1, NPC_CTCF, ES_CTCF, es2i_CTCF, window=1000, bins=100, ylim=6, averaged=1)
    pileupplotter('output/CTCF_over_ES_only_YY1_average', ES_only_YY1, NPC_CTCF, ES_CTCF, es2i_CTCF, window=1000, bins=100, ylim=6, averaged=1)
    pileupplotter('output/CTCF_over_Constit_YY1_average', Constit_YY1, NPC_CTCF, ES_CTCF, es2i_CTCF, window=1000, bins=100, ylim=6, averaged=1)

if __name__ == "__main__":
    main()



