#!usr/bin/perl
use strict;
use warnings;

=for

shuffleBed -excl /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/unmappable.bed -noOverlapping -i ../../../a_peaks/Wt_PML_peaks.bed -g /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/ChromInfo.txt | sort -k 1,1V -k 2,2n | intersectBed -wa -wb -a stdin -b ../../../../a_old/PML_KO_H3/c_newRatios/a_1kb/Ratios.sorted.bedgraph > KO_H3Random
shuffleBed -excl /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/unmappable.bed -noOverlapping -i ../../../a_peaks/Wt_PML_peaks.bed -g /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/ChromInfo.txt | sort -k 1,1V -k 2,2n | intersectBed -wa -wb -a stdin -b ../../../../a_old/PML_KO_H33/c_newRatios/a_1kb/Ratios.sorted.bedgraph > KO_H33Random
shuffleBed -excl /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/unmappable.bed -noOverlapping -i ../../../a_peaks/Wt_PML_peaks.bed -g /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/ChromInfo.txt | sort -k 1,1V -k 2,2n | intersectBed -wa -wb -a stdin -b ../../../../a_old/PML_KO_H3K27me3/c_newRatios/a_1kb/Ratios.sorted.bedgraph > KO_H3K27me3Random
shuffleBed -excl /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/unmappable.bed -noOverlapping -i ../../../a_peaks/Wt_PML_peaks.bed -g /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/ChromInfo.txt | sort -k 1,1V -k 2,2n | intersectBed -wa -wb -a stdin -b ../../../../a_old/PML_KO_H3K9me3/c_newRatios/a_1kb/Ratios.sorted.bedgraph > KO_H3K9me3Random

shuffleBed -excl /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/unmappable.bed -noOverlapping -i ../../../a_peaks/Wt_PML_peaks.bed -g /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/ChromInfo.txt | sort -k 1,1V -k 2,2n | intersectBed -wa -wb -a stdin -b ../../../../a_old/Wt_H3/c_newRatios/a_1kb/Ratios.sorted.bedgraph > WT_H3Random
shuffleBed -excl /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/unmappable.bed -noOverlapping -i ../../../a_peaks/Wt_PML_peaks.bed -g /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/ChromInfo.txt | sort -k 1,1V -k 2,2n | intersectBed -wa -wb -a stdin -b ../../../../a_old/Wt_H33/c_newRatios/a_1kb/Ratios.sorted.bedgraph > WT_H33Random
shuffleBed -excl /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/unmappable.bed -noOverlapping -i ../../../a_peaks/Wt_PML_peaks.bed -g /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/ChromInfo.txt | sort -k 1,1V -k 2,2n | intersectBed -wa -wb -a stdin -b ../../../../a_old/Wt_H3K27me3/c_newRatios/a_1kb/Ratios.sorted.bedgraph > WT_H3K27me3Random
shuffleBed -excl /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/unmappable.bed -noOverlapping -i ../../../a_peaks/Wt_PML_peaks.bed -g /data/as/annotation/Mus_musculus/UCSC/mm10/Annotation/Genes/ChromInfo.txt | sort -k 1,1V -k 2,2n | intersectBed -wa -wb -a stdin -b ../../../../a_old/Wt_H3K9me3/c_newRatios/a_1kb/Ratios.sorted.bedgraph > WT_H3K9me3Random

=cut

my @files = @ARGV;

my %ratios;

foreach my $file (@files) {
	chomp($file);
	my %peaks = ();
	open(FILE, $file) || die "Cannot open $file $! \n";
	while (my $line = <FILE>) {
		chomp($line);
		my @sl = split(/\t/, $line);
		$peaks{$sl[3]}{"Sum"} += $sl[-1];
		$peaks{$sl[3]}{"Count"} += 1;
	}
	close(FILE);
	foreach my $peak (keys %peaks) {
		my $average_ratio = $peaks{$peak}{"Sum"} / $peaks{$peak}{"Count"};
		$ratios{$file}{$peak} = $average_ratio;
	}
}

open(OUT, ">", "Avg_PML_ratiosRandom") || die "Cannot open OUT $! \n";

foreach my $file (keys %ratios) {
	foreach my $peak (keys %{$ratios{$file}}) {
		my @sf = split(/_/, $file);
		my $type = $sf[0];
		my $sample = $sf[1];
		my $ratio = $ratios{$file}{$peak};
		my $outline = join("\t", $type, $sample, $ratio);
		print OUT "$outline\n";
	}
}

close(OUT);
