#!usr/bin/perl
use strict;
use warnings;

my @files = @ARGV;

my %ratios;

foreach my $file (@files) {
	chomp($file);
	my %peaks = ();
	open(FILE, $file) || die "Cannot open $file $! \n";
	while (my $line = <FILE>) {
		chomp($line);
		my @sl = split(/\t/, $line);
		$peaks{$sl[3]}{"Sum"} += $sl[-1];
		$peaks{$sl[3]}{"Count"} += 1;
	}
	close(FILE);
	foreach my $peak (keys %peaks) {
		my $average_ratio = $peaks{$peak}{"Sum"} / $peaks{$peak}{"Count"};
		$ratios{$file}{$peak} = $average_ratio;
	}
}

open(OUT, ">", "Avg_PML_ratios") || die "Cannot open OUT $! \n";

foreach my $file (keys %ratios) {
	foreach my $peak (keys %{$ratios{$file}}) {
		my @sf = split(/_/, $file);
		my $type = $sf[0];
		my $sample = $sf[1];
		my $ratio = $ratios{$file}{$peak};
		my $outline = join("\t", $type, $sample, $ratio);
		print OUT "$outline\n";
	}
}

close(OUT);
