#!usr/bin/perl
use strict;
use warnings;
use threads;
use threads::shared;

my @genes = qx(ls ../d_intersectWithGenes/b_unique/*.txt);
my @peaks = qx(ls ../a_peaks/*.bed);

my %gs;
my %ps;

my @threads;

foreach my $file (@genes) {
	chomp($file);
	my @sf = split(/\//, $file);
	my @sf2 = split(/\./, $sf[-1]);
	my $fname = $sf2[0];
	$gs{$fname} = $file;
}

foreach my $file (@peaks) {
	chomp($file);
	my @sf = split(/\//, $file);
	my @sf2 = split(/\./, $sf[-1]);
	my @sf3 = split(/_/, $sf2[0]);
	pop(@sf3);
	my $fname = join("_", @sf3);
	$ps{$fname} = $file;
}

foreach my $file (keys %ps) {
        my $t = threads->new(\&sub1, $file);
        push(@threads,$t);
}

foreach (@threads) {
        my $num = $_->join;
}

sub sub1 {
	my $file = shift;
	open (PEAK, $ps{$file}) || die "Cannot open $ps{$file} $!\n";
	open (GENE, $gs{$file}) || die "Cannot open $gs{$file} $!\n";
	my $g_count = 0;
	my $p_length = 0;
	while (my $line = <GENE>) {
		$g_count++;
	}
	while (my $line = <PEAK>) {
		chomp($line);
		my @sl = split(/\t/, $line);
		$p_length += $sl[2] - $sl[1];
	}
	my $genes_per_mb = $g_count / $p_length;
	$genes_per_mb = $genes_per_mb * 1000000;
	print "$file\t$genes_per_mb\n"
}

