#!usr/bin/perl
use strict;
use warnings;

my @files = qx(ls ../a_raw/*.bed);

foreach my $file (@files) {
	chomp($file);
	open (FILE, $file) || die "Cannot open $file $!\n";
	my %genes = ();
	my @tg;
	while (my $line = <FILE>) {
		chomp($line);
		my @sl = split(/\t/, $line);
		$genes{$sl[7]} = $line;
	}
	my $count = 0;
	my @sf = split(/\//, $file);
	my $out = pop(@sf);
	open(OUT, ">", $out) || die "Cannot open $out $!\n";
	my @name2 = split(/\./, $out);
	my $out2 = join("", $name2[0], ".txt");
	open(OUT2, ">", $out2) || die "Cannot open $out2 $!\n";
	foreach my $key (keys %genes) {
		$count += 1;
		print OUT "$genes{$key}\n";
		print OUT2 "$key\n";
	}
	print "$file\t$count\n";
}

