#!usr/bin/perl
use strict;
use warnings;
use Statistics::Basic qw(:all);

my @files = qx(ls ../a_peaks/*.bed);

foreach my $file (@files) {
	chomp($file);
	my @sf = split(/\//, $file);
	open (FILE, $file) || die "Cannot open $file $!\n";
	my @lengths;
	my $fname = pop(@sf);
	while (my $line = <FILE>) {
		chomp($line);
		my @sl = split(/\t/, $line);
		my $length = $sl[2] - $sl[1];
		push(@lengths, $length);
	}
	@lengths = sort {$a <=> $b} (@lengths);
	my $max_length = $lengths[-1];
	my $min_length = $lengths[0];
	my $median_length = median(@lengths);
	$median_length =~ s/,//g;
	my $mean_length = mean(@lengths);
	$mean_length =~ s/,//g;
	print "$fname\n$mean_length\t$median_length\t$min_length\t$max_length\n";
}

