/* 
    This program is free software: you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation, either version 3 of the License, or 
    (at your option) any later version. 
 
    This program is distributed in the hope that it will be useful, 
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details. 
 
    You should have received a copy of the GNU General Public License 
    along with this program.  If not, see <http://www.gnu.org/licenses/> 
*/

#include <cassert>
#include <cstdio>
#include <cstdlib>

#include <iostream>

using namespace std;

/*! \file printnm.cpp

   \brief print the number of vertices and edges in an input
          graph

    \author Darren Strash (first name DOT last name AT gmail DOT com)

    \copyright Copyright (c) 2011 Darren Strash. This code is released under the GNU Public License (GPL) 3.0.

    \image html gplv3-127x51.png

    \htmlonly
    <center>
    <a href="gpl-3.0-standalone.html">See GPL 3.0 here</a>
    </center>
    \endhtmlonly
*/

int main()
{
    int n,m;

    if(scanf("%d", &n)!=1)
        exit(1);
    if(scanf("%d", &m)!=1)
        exit(1);
    fprintf(stderr, "Number of vertices: %d\n", n);
    fprintf(stderr, "Number of edges: %d\n", m/2);
    cout << n << " " << m/2 << endl;

    return 0;
}
