/***** This code was generated by Yaggo. Do not edit ******/

/* SuperRead pipeline
 * Copyright (C) 2012  Genome group at University of Maryland.
 *
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



#ifndef __CMDLINE_PARSE_HPP__
#define __CMDLINE_PARSE_HPP__

#include <stdint.h>
#include <unistd.h>
#include <stdlib.h>
#include <getopt.h>
#include <errno.h>
#include <string.h>
#include <stdexcept>
#include <string>
#include <limits>
#include <vector>
#include <iostream>
#include <sstream>
#include <memory>

class cmdline_parse {
 // Boiler plate stuff. Conversion from string to other formats
  static bool adjust_double_si_suffix(double &res, const char *suffix) {
    if(*suffix == '\0')
      return true;
    if(*(suffix + 1) != '\0')
      return false;

    switch(*suffix) {
    case 'a': res *= 1e-18; break;
    case 'f': res *= 1e-15; break;
    case 'p': res *= 1e-12; break;
    case 'n': res *= 1e-9;  break;
    case 'u': res *= 1e-6;  break;
    case 'm': res *= 1e-3;  break;
    case 'k': res *= 1e3;   break;
    case 'M': res *= 1e6;   break;
    case 'G': res *= 1e9;   break;
    case 'T': res *= 1e12;  break;
    case 'P': res *= 1e15;  break;
    case 'E': res *= 1e18;  break;
    default: return false;
    }
    return true;
  }

  static double conv_double(const char *str, ::std::string &err, bool si_suffix) {
    char *endptr = 0;
    errno = 0;
    double res = strtod(str, &endptr);
    if(errno) {
      err.assign(strerror(errno));
      return (double)0.0;
    }
    bool invalid =
      si_suffix ? !adjust_double_si_suffix(res, endptr) : *endptr != '\0';
    if(invalid) {
      err.assign("Invalid character");
      return (double)0.0;
    }
    return res;
  }

  static int conv_enum(const char* str, ::std::string& err, const char* const strs[]) {
    int res = 0;
    for(const char* const* cstr = strs; *cstr; ++cstr, ++res)
      if(!strcmp(*cstr, str))
        return res;
    err += "Invalid constant '";
    err += str;
    err += "'. Expected one of { ";
    for(const char* const* cstr = strs; *cstr; ++cstr) {
      if(cstr != strs)
        err += ", ";
      err += *cstr;
    }
    err += " }";
    return -1;
  }

  template<typename T>
  static bool adjust_int_si_suffix(T &res, const char *suffix) {
    if(*suffix == '\0')
      return true;
    if(*(suffix + 1) != '\0')
      return false;

    switch(*suffix) {
    case 'k': res *= (T)1000; break;
    case 'M': res *= (T)1000000; break;
    case 'G': res *= (T)1000000000; break;
    case 'T': res *= (T)1000000000000; break;
    case 'P': res *= (T)1000000000000000; break;
    case 'E': res *= (T)1000000000000000000; break;
    default: return false;
    }
    return true;
  }

  template<typename T>
  static T conv_int(const char *str, ::std::string &err, bool si_suffix) {
    char *endptr = 0;
    errno = 0;
    long long int res = strtoll(str, &endptr, 0);
    if(errno) {
      err.assign(strerror(errno));
      return (T)0;
    }
    bool invalid =
      si_suffix ? !adjust_int_si_suffix(res, endptr) : *endptr != '\0';
    if(invalid) {
      err.assign("Invalid character");
      return (T)0;
    }
    if(res > ::std::numeric_limits<T>::max() ||
       res < ::std::numeric_limits<T>::min()) {
      err.assign("Value out of range");
      return (T)0;
    }
    return (T)res;
  }

  template<typename T>
  static T conv_uint(const char *str, ::std::string &err, bool si_suffix) {
    char *endptr = 0;
    errno = 0;
    while(isspace(*str)) { ++str; }
    if(*str == '-') {
      err.assign("Negative value");
      return (T)0;
    }
    unsigned long long int res = strtoull(str, &endptr, 0);
    if(errno) {
      err.assign(strerror(errno));
      return (T)0;
    }
    bool invalid =
      si_suffix ? !adjust_int_si_suffix(res, endptr) : *endptr != '\0';
    if(invalid) {
      err.assign("Invalid character");
      return (T)0;
    }
    if(res > ::std::numeric_limits<T>::max()) {
      err.assign("Value out of range");
      return (T)0;
    }
    return (T)res;
  }

  template<typename T>
  static ::std::string vec_str(const std::vector<T> &vec) {
    ::std::ostringstream os;
    for(typename ::std::vector<T>::const_iterator it = vec.begin();
        it != vec.end(); ++it) {
      if(it != vec.begin())
        os << ",";
      os << *it;
    }
    return os.str();
  }

  class string : public ::std::string {
  public:
    string() : ::std::string() {}
    explicit string(const ::std::string &s) : std::string(s) {}
    explicit string(const char *s) : ::std::string(s) {}
    int as_enum(const char* const strs[]) {
      ::std::string err;
      int res = conv_enum((const char*)this->c_str(), err, strs);
      if(!err.empty())
        throw ::std::runtime_error(err);
      return res;
    }


    uint32_t as_uint32_suffix() const { return as_uint32(true); }
    uint32_t as_uint32(bool si_suffix = false) const {
      ::std::string err;
      uint32_t res = conv_uint<uint32_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to uint32_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    uint64_t as_uint64_suffix() const { return as_uint64(true); }
    uint64_t as_uint64(bool si_suffix = false) const {
      ::std::string err;
      uint64_t res = conv_uint<uint64_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to uint64_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    int32_t as_int32_suffix() const { return as_int32(true); }
    int32_t as_int32(bool si_suffix = false) const {
      ::std::string err;
      int32_t res = conv_int<int32_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to int32_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    int64_t as_int64_suffix() const { return as_int64(true); }
    int64_t as_int64(bool si_suffix = false) const {
      ::std::string err;
      int64_t res = conv_int<int64_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to int64_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    int as_int_suffix() const { return as_int(true); }
    int as_int(bool si_suffix = false) const {
      ::std::string err;
      int res = conv_int<int>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to int_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    long as_long_suffix() const { return as_long(true); }
    long as_long(bool si_suffix = false) const {
      ::std::string err;
      long res = conv_int<long>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to long_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    double as_double_suffix() const { return as_double(true); }
    double as_double(bool si_suffix = false) const {
      ::std::string err;
      double res = conv_double((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to double_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
  };

public:
  int                            num_threads_arg;
  bool                           num_threads_given;
  const char *                   output_arg;
  bool                           output_given;
  const char *                   error_out_arg;
  bool                           error_out_given;
  bool                           keep_directories_flag;
  bool                           jumping_read_joining_run_flag;
  const char *                   Celera_terminator_directory_arg;
  bool                           Celera_terminator_directory_given;
  int                            max_nodes_arg;
  bool                           max_nodes_given;
  int                            min_kmer_len_arg;
  bool                           min_kmer_len_given;
  int                            max_kmer_len_arg;
  bool                           max_kmer_len_given;
  int                            mean_for_faux_inserts_arg;
  bool                           mean_for_faux_inserts_given;
  int                            join_aggressive_arg;
  bool                           join_aggressive_given;
  int                            stdev_for_faux_inserts_arg;
  bool                           stdev_for_faux_inserts_given;
  int                            num_stdevs_allowed_arg;
  bool                           num_stdevs_allowed_given;
  const char *                   mean_and_stdev_file_arg;
  bool                           mean_and_stdev_file_given;
  const char *                   output_dir_arg;
  bool                           output_dir_given;
  const char *                   contig_end_sequence_file_arg;
  bool                           contig_end_sequence_file_given;
  int                            num_joins_per_directory_arg;
  bool                           num_joins_per_directory_given;
  int                            skip_gaps_arg;
  bool                           skip_gaps_given;
  const char *                   dir_for_read_sequences_arg;
  bool                           dir_for_read_sequences_given;

  enum {
    START_OPT = 1000,
    KEEP_DIRECTORIES_OPT,
    JUMPING_READ_JOINING_RUN_OPT,
    CELERA_TERMINATOR_DIRECTORY_OPT,
    MAX_NODES_OPT,
    MIN_KMER_LEN_OPT,
    MAX_KMER_LEN_OPT,
    MEAN_FOR_FAUX_INSERTS_OPT,
    JOIN_AGGRESSIVE_OPT,
    STDEV_FOR_FAUX_INSERTS_OPT,
    NUM_STDEVS_ALLOWED_OPT,
    MEAN_AND_STDEV_FILE_OPT,
    OUTPUT_DIR_OPT,
    CONTIG_END_SEQUENCE_FILE_OPT,
    NUM_JOINS_PER_DIRECTORY_OPT,
    SKIP_GAPS_OPT,
    DIR_FOR_READ_SEQUENCES_OPT
  };

  cmdline_parse() :
    num_threads_arg((int)1), num_threads_given(false),
    output_arg("output.txt"), output_given(false),
    error_out_arg("err_dirs.txt"), error_out_given(false),
    keep_directories_flag(false),
    jumping_read_joining_run_flag(false),
    Celera_terminator_directory_arg(""), Celera_terminator_directory_given(false),
    max_nodes_arg((int)200000), max_nodes_given(false),
    min_kmer_len_arg((int)17), min_kmer_len_given(false),
    max_kmer_len_arg((int)65), max_kmer_len_given(false),
    mean_for_faux_inserts_arg((int)500), mean_for_faux_inserts_given(false),
    join_aggressive_arg((int)0), join_aggressive_given(false),
    stdev_for_faux_inserts_arg((int)200), stdev_for_faux_inserts_given(false),
    num_stdevs_allowed_arg((int)5), num_stdevs_allowed_given(false),
    mean_and_stdev_file_arg(""), mean_and_stdev_file_given(false),
    output_dir_arg("."), output_dir_given(false),
    contig_end_sequence_file_arg(""), contig_end_sequence_file_given(false),
    num_joins_per_directory_arg((int)1), num_joins_per_directory_given(false),
    skip_gaps_arg((int)0), skip_gaps_given(false),
    dir_for_read_sequences_arg(""), dir_for_read_sequences_given(false)
  { }

  cmdline_parse(int argc, char* argv[]) :
    num_threads_arg((int)1), num_threads_given(false),
    output_arg("output.txt"), output_given(false),
    error_out_arg("err_dirs.txt"), error_out_given(false),
    keep_directories_flag(false),
    jumping_read_joining_run_flag(false),
    Celera_terminator_directory_arg(""), Celera_terminator_directory_given(false),
    max_nodes_arg((int)200000), max_nodes_given(false),
    min_kmer_len_arg((int)17), min_kmer_len_given(false),
    max_kmer_len_arg((int)65), max_kmer_len_given(false),
    mean_for_faux_inserts_arg((int)500), mean_for_faux_inserts_given(false),
    join_aggressive_arg((int)0), join_aggressive_given(false),
    stdev_for_faux_inserts_arg((int)200), stdev_for_faux_inserts_given(false),
    num_stdevs_allowed_arg((int)5), num_stdevs_allowed_given(false),
    mean_and_stdev_file_arg(""), mean_and_stdev_file_given(false),
    output_dir_arg("."), output_dir_given(false),
    contig_end_sequence_file_arg(""), contig_end_sequence_file_given(false),
    num_joins_per_directory_arg((int)1), num_joins_per_directory_given(false),
    skip_gaps_arg((int)0), skip_gaps_given(false),
    dir_for_read_sequences_arg(""), dir_for_read_sequences_given(false)
  { parse(argc, argv); }

  void parse(int argc, char* argv[]) {
    static struct option long_options[] = {
      {"num-threads", 1, 0, 't'},
      {"output", 1, 0, 'o'},
      {"error-out", 1, 0, 'e'},
      {"keep-directories", 0, 0, KEEP_DIRECTORIES_OPT},
      {"jumping-read-joining-run", 0, 0, JUMPING_READ_JOINING_RUN_OPT},
      {"Celera-terminator-directory", 1, 0, CELERA_TERMINATOR_DIRECTORY_OPT},
      {"max-nodes", 1, 0, MAX_NODES_OPT},
      {"min-kmer-len", 1, 0, MIN_KMER_LEN_OPT},
      {"max-kmer-len", 1, 0, MAX_KMER_LEN_OPT},
      {"mean-for-faux-inserts", 1, 0, MEAN_FOR_FAUX_INSERTS_OPT},
      {"join-aggressive", 1, 0, JOIN_AGGRESSIVE_OPT},
      {"stdev-for-faux-inserts", 1, 0, STDEV_FOR_FAUX_INSERTS_OPT},
      {"num-stdevs-allowed", 1, 0, NUM_STDEVS_ALLOWED_OPT},
      {"mean-and-stdev-file", 1, 0, MEAN_AND_STDEV_FILE_OPT},
      {"output-dir", 1, 0, OUTPUT_DIR_OPT},
      {"contig-end-sequence-file", 1, 0, CONTIG_END_SEQUENCE_FILE_OPT},
      {"num-joins-per-directory", 1, 0, NUM_JOINS_PER_DIRECTORY_OPT},
      {"skip-gaps", 1, 0, SKIP_GAPS_OPT},
      {"dir-for-read-sequences", 1, 0, DIR_FOR_READ_SEQUENCES_OPT},
      {"help", 0, 0, 'h'},
      {"usage", 0, 0, 'U'},
      {"version", 0, 0, 'V'},
      {0, 0, 0, 0}
    };
    static const char *short_options = "hVUt:o:e:";

    ::std::string err;
#define CHECK_ERR(type,val,which) if(!err.empty()) { ::std::cerr << "Invalid " #type " '" << val << "' for [" which "]: " << err << "\n"; exit(1); }
    while(true) {
      int index = -1;
      int c = getopt_long(argc, argv, short_options, long_options, &index);
      if(c == -1) break;
      switch(c) {
      case ':':
        ::std::cerr << "Missing required argument for "
                  << (index == -1 ? ::std::string(1, (char)optopt) : std::string(long_options[index].name))
                  << ::std::endl;
        exit(1);
      case 'h':
        ::std::cout << usage() << "\n\n" << help() << std::endl;
        exit(0);
      case 'U':
        ::std::cout << usage() << "\nUse --help for more information." << std::endl;
        exit(0);
      case 'V':
        print_version();
        exit(0);
      case '?':
        ::std::cerr << "Use --usage or --help for some help\n";
        exit(1);
      case 't':
        num_threads_given = true;
        num_threads_arg = conv_int<int>((const char*)optarg, err, false);
        CHECK_ERR(int_t, optarg, "-t, --num-threads=int")
        break;
      case 'o':
        output_given = true;
        output_arg = optarg;
        break;
      case 'e':
        error_out_given = true;
        error_out_arg = optarg;
        break;
      case KEEP_DIRECTORIES_OPT:
        keep_directories_flag = true;
        break;
      case JUMPING_READ_JOINING_RUN_OPT:
        jumping_read_joining_run_flag = true;
        break;
      case CELERA_TERMINATOR_DIRECTORY_OPT:
        Celera_terminator_directory_given = true;
        Celera_terminator_directory_arg = optarg;
        break;
      case MAX_NODES_OPT:
        max_nodes_given = true;
        max_nodes_arg = conv_int<int>((const char*)optarg, err, false);
        CHECK_ERR(int_t, optarg, "    --max-nodes=int")
        break;
      case MIN_KMER_LEN_OPT:
        min_kmer_len_given = true;
        min_kmer_len_arg = conv_int<int>((const char*)optarg, err, false);
        CHECK_ERR(int_t, optarg, "    --min-kmer-len=int")
        break;
      case MAX_KMER_LEN_OPT:
        max_kmer_len_given = true;
        max_kmer_len_arg = conv_int<int>((const char*)optarg, err, false);
        CHECK_ERR(int_t, optarg, "    --max-kmer-len=int")
        break;
      case MEAN_FOR_FAUX_INSERTS_OPT:
        mean_for_faux_inserts_given = true;
        mean_for_faux_inserts_arg = conv_int<int>((const char*)optarg, err, false);
        CHECK_ERR(int_t, optarg, "    --mean-for-faux-inserts=int")
        break;
      case JOIN_AGGRESSIVE_OPT:
        join_aggressive_given = true;
        join_aggressive_arg = conv_int<int>((const char*)optarg, err, false);
        CHECK_ERR(int_t, optarg, "    --join-aggressive=int")
        break;
      case STDEV_FOR_FAUX_INSERTS_OPT:
        stdev_for_faux_inserts_given = true;
        stdev_for_faux_inserts_arg = conv_int<int>((const char*)optarg, err, false);
        CHECK_ERR(int_t, optarg, "    --stdev-for-faux-inserts=int")
        break;
      case NUM_STDEVS_ALLOWED_OPT:
        num_stdevs_allowed_given = true;
        num_stdevs_allowed_arg = conv_int<int>((const char*)optarg, err, false);
        CHECK_ERR(int_t, optarg, "    --num-stdevs-allowed=int")
        break;
      case MEAN_AND_STDEV_FILE_OPT:
        mean_and_stdev_file_given = true;
        mean_and_stdev_file_arg = optarg;
        break;
      case OUTPUT_DIR_OPT:
        output_dir_given = true;
        output_dir_arg = optarg;
        break;
      case CONTIG_END_SEQUENCE_FILE_OPT:
        contig_end_sequence_file_given = true;
        contig_end_sequence_file_arg = optarg;
        break;
      case NUM_JOINS_PER_DIRECTORY_OPT:
        num_joins_per_directory_given = true;
        num_joins_per_directory_arg = conv_int<int>((const char*)optarg, err, false);
        CHECK_ERR(int_t, optarg, "    --num-joins-per-directory=int")
        break;
      case SKIP_GAPS_OPT:
        skip_gaps_given = true;
        skip_gaps_arg = conv_int<int>((const char*)optarg, err, false);
        CHECK_ERR(int_t, optarg, "    --skip-gaps=int")
        break;
      case DIR_FOR_READ_SEQUENCES_OPT:
        dir_for_read_sequences_given = true;
        dir_for_read_sequences_arg = optarg;
        break;
      }
    }

    // Check that required switches are present
    if(!Celera_terminator_directory_given)
      error("[    --Celera-terminator-directory=path] required switch");
    if(!contig_end_sequence_file_given)
      error("[    --contig-end-sequence-file=path] required switch");
    if(!dir_for_read_sequences_given)
      error("[    --dir-for-read-sequences=path] required switch");

    // Parse arguments
    if(argc - optind != 0)
      error("Requires exactly 0 argument.");
  }
  static const char * usage() { return "Usage: cmdline_parse [options]"; }
  class error {
    int code_;
    std::ostringstream msg_;

    // Select the correct version (GNU or XSI) version of
    // strerror_r. strerror_ behaves like the GNU version of strerror_r,
    // regardless of which version is provided by the system.
    static const char* strerror__(char* buf, int res) {
      return res != -1 ? buf : "Invalid error";
    }
    static const char* strerror__(char* buf, char* res) {
      return res;
    }
    static const char* strerror_(int err, char* buf, size_t buflen) {
      return strerror__(buf, strerror_r(err, buf, buflen));
    }
    struct no_t { };

  public:
    static no_t no;
    error(int code = EXIT_FAILURE) : code_(code) { }
    explicit error(const char* msg, int code = EXIT_FAILURE) : code_(code)
      { msg_ << msg; }
    error(const std::string& msg, int code = EXIT_FAILURE) : code_(code)
      { msg_ << msg; }
    error& operator<<(no_t) {
      char buf[1024];
      msg_ << ": " << strerror_(errno, buf, sizeof(buf));
      return *this;
    }
    template<typename T>
    error& operator<<(const T& x) { msg_ << x; return (*this); }
    ~error() {
      ::std::cerr << "Error: " << msg_.str() << "\n"
                  << usage() << "\n"
                  << "Use --help for more information"
                  << ::std::endl;
      exit(code_);
    }
  };
  static const char * help() { return
    "Run the local directories for local gap closing and collect the results.\n\n\n\n"
    "Options (default value in (), *required):\n"
    " -t, --num-threads=int                    Number of threads (1)\n"
    " -o, --output=path                        Output file with sequence and read placement (output.txt)\n"
    " -e, --error-out=path                     Output file with directories that failed (err_dirs.txt)\n"
    "     --keep-directories                   Keep the individual gap directories (false)\n"
    "     --jumping-read-joining-run           This is a run to find short reversed jumping read inserts (false)\n"
    "     --Celera-terminator-directory=path  *The location of the terminator directory for the Celera run\n"
    "     --max-nodes=int                      Max nodes to use when closing gaps locally (200000)\n"
    "     --min-kmer-len=int                   Minimum k-mer length used when closing gaps locally (17)\n"
    "     --max-kmer-len=int                   Maximum k-mer length used when closing gaps locally (65)\n"
    "     --mean-for-faux-inserts=int          Mean specified when joining the ends of the contigs (500)\n"
    "     --join-aggressive=int                If set to 1 calls the pair joined if there is any path (as opposed to a unique path) (0)\n"
    "     --stdev-for-faux-inserts=int         Standard deviation specified when joining the ends of the contigs (200)\n"
    "     --num-stdevs-allowed=int             Number of standard deviations the join length can be from the mean when trying to join a mate pair. (5)\n"
    "     --mean-and-stdev-file=path           File with means and standard deviations for each gap\n"
    "     --output-dir=path                    The subdirectory to put the individual gaps into (.)\n"
    "     --contig-end-sequence-file=path     *Name of the file containing the contig end sequences for joining\n"
    "     --num-joins-per-directory=int        Number of joins put in each directory (1)\n"
    "     --skip-gaps=int                      Number of gaps to skip -- useful for restarting (0)\n"
    "     --dir-for-read-sequences=path       *Name of dir where readFile.### exist; should be absolute\n"
    " -U, --usage                              Usage\n"
    " -h, --help                               This message\n"
    " -V, --version                            Version";
  }
  static const char* hidden() { return ""; }
  void print_version(::std::ostream &os = std::cout) const {
#ifndef PACKAGE_VERSION
#define PACKAGE_VERSION "0.0.0"
#endif
    os << PACKAGE_VERSION << "\n";
  }
  void dump(::std::ostream &os = std::cout) {
    os << "num_threads_given:" << num_threads_given << " num_threads_arg:" << num_threads_arg << "\n";
    os << "output_given:" << output_given << " output_arg:" << output_arg << "\n";
    os << "error_out_given:" << error_out_given << " error_out_arg:" << error_out_arg << "\n";
    os << "keep_directories_flag:" << keep_directories_flag << "\n";
    os << "jumping_read_joining_run_flag:" << jumping_read_joining_run_flag << "\n";
    os << "Celera_terminator_directory_given:" << Celera_terminator_directory_given << " Celera_terminator_directory_arg:" << Celera_terminator_directory_arg << "\n";
    os << "max_nodes_given:" << max_nodes_given << " max_nodes_arg:" << max_nodes_arg << "\n";
    os << "min_kmer_len_given:" << min_kmer_len_given << " min_kmer_len_arg:" << min_kmer_len_arg << "\n";
    os << "max_kmer_len_given:" << max_kmer_len_given << " max_kmer_len_arg:" << max_kmer_len_arg << "\n";
    os << "mean_for_faux_inserts_given:" << mean_for_faux_inserts_given << " mean_for_faux_inserts_arg:" << mean_for_faux_inserts_arg << "\n";
    os << "join_aggressive_given:" << join_aggressive_given << " join_aggressive_arg:" << join_aggressive_arg << "\n";
    os << "stdev_for_faux_inserts_given:" << stdev_for_faux_inserts_given << " stdev_for_faux_inserts_arg:" << stdev_for_faux_inserts_arg << "\n";
    os << "num_stdevs_allowed_given:" << num_stdevs_allowed_given << " num_stdevs_allowed_arg:" << num_stdevs_allowed_arg << "\n";
    os << "mean_and_stdev_file_given:" << mean_and_stdev_file_given << " mean_and_stdev_file_arg:" << mean_and_stdev_file_arg << "\n";
    os << "output_dir_given:" << output_dir_given << " output_dir_arg:" << output_dir_arg << "\n";
    os << "contig_end_sequence_file_given:" << contig_end_sequence_file_given << " contig_end_sequence_file_arg:" << contig_end_sequence_file_arg << "\n";
    os << "num_joins_per_directory_given:" << num_joins_per_directory_given << " num_joins_per_directory_arg:" << num_joins_per_directory_arg << "\n";
    os << "skip_gaps_given:" << skip_gaps_given << " skip_gaps_arg:" << skip_gaps_arg << "\n";
    os << "dir_for_read_sequences_given:" << dir_for_read_sequences_given << " dir_for_read_sequences_arg:" << dir_for_read_sequences_arg << "\n";
  }
};
#endif // __CMDLINE_PARSE_HPP__"
