#! /usr/bin/env perl
# Pass 3 args:
# 1: The file with fields: gapNum, joinSeq, fauxReadName1, gapNum, fauxRead1offset, fauxRead1ori, fauxReadName2, gapNum, fauxRead2offset, fauxRead2ori
# 2: The name of the file where the joining super-read sequence goes
# 3: The name of the file where the faux reads placements go
# Optional args and flags:
# --mean-and-stdev-file fn ; file generated by 
#  getMeanAndStdevForGapsByGapNumUsingCeleraTerminatorDirectory.perl
&processArgs;

open (FILE, $infile);
while ($line = <FILE>) {
    chomp ($line);
    @flds = split (" ", $line);
    $gapNum = $flds[0];
    $sequence[$gapNum] = $flds[1];
    $placementInfo[$gapNum] = "@flds[2..5]\n@flds[6..9]\n";
    $gapSeqLen[$gapNum] = $flds[8] - $flds[4];
    if ($gapSeqLen[$gapNum] < 0) {
	$gapSeqLen[$gapNum] *= -1; }
}
close (FILE);

if ($meanAndStdevFile) {
    open (FILE, $meanAndStdevFile);
    while ($line = <FILE>) {
	chomp ($line);
	@flds = split (" ", $line);
	$gapNum = $flds[0];
	$gapMean = $flds[1];
	$gapStdev = $flds[2];
	if ($gapSeqLen[$gapNum] < $gapMean - $gapStdev * $numStdevsAllowed) {
	    $fail[$gapNum] = 1; }
	if ($gapSeqLen[$gapNum] > $gapMean + $gapStdev * $numStdevsAllowed) {
	    $fail[$gapNum] = 1; }
    }
    close (FILE);
}

open (OUTFILE1, ">$outputSequenceFile");
open (OUTFILE2, ">$outputPlacementFile");
for ($gapNum=0; $gapNum<=$#sequence; $gapNum++) {
    next unless ($sequence[$gapNum]);
    next if ($fail[$gapNum]);
    print OUTFILE1 ">$gapNum\n$sequence[$gapNum]\n";
    print OUTFILE2 $placementInfo[$gapNum]; }
close (OUTFILE1);
close (OUTFILE2);

sub reportUsage {
    open (FILE, $0);
    $line = <FILE>;
    while ($line = <FILE>) {
	last unless ($line =~ /^\#/);
	chomp ($line);
	($line) = ($line =~ /^..(.*)$/);
	print "$line\n"; }
    close (FILE);
    exit (0);
}

sub processArgs
{
    my ($currentArgNum, $i);
    $currentArgNum = 0;
    $numStdevsAllowed = 3;
    for ($i=0; $i<=$#ARGV; $i++) {
	if (($ARGV[$i] =~ /^\-\-h/i) || ($ARGV[$i] =~ /^\-h/i)) {
	    &reportUsage; }
	if ($ARGV[$i] eq "--mean-and-stdev-file") {
	    ++$i;
	    $meanAndStdevFile = $ARGV[$i];
	    next; }
	if ($ARGV[$i] eq "--num-stdevs-allowed") {
	    ++$i;
	    $numStdevsAllowed = $ARGV[$i];
	    next; }
	if ($currentArgNum == 0) {
	    $infile = $ARGV[$i];
	    ++$currentArgNum;
	    next; }
	if ($currentArgNum == 1) {
	    $outputSequenceFile = $ARGV[$i];
	    ++$currentArgNum;
	    next; }
	if ($currentArgNum == 2) {
	    $outputPlacementFile = $ARGV[$i];
	    ++$currentArgNum;
	    next; }
	++$currentArgNum;
    }
    if ($currentArgNum > 3) { &reportUsage; }
}

