/***** This code was generated by Yaggo. Do not edit ******/

/* SuperRead pipeline
 * Copyright (C) 2012  Genome group at University of Maryland.
 *
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */



#ifndef __CMDLINE_PARSE_HPP__
#define __CMDLINE_PARSE_HPP__

#include <stdint.h>
#include <unistd.h>
#include <stdlib.h>
#include <getopt.h>
#include <errno.h>
#include <string.h>
#include <stdexcept>
#include <string>
#include <limits>
#include <vector>
#include <iostream>
#include <sstream>
#include <memory>

class cmdline_parse {
 // Boiler plate stuff. Conversion from string to other formats
  static bool adjust_double_si_suffix(double &res, const char *suffix) {
    if(*suffix == '\0')
      return true;
    if(*(suffix + 1) != '\0')
      return false;

    switch(*suffix) {
    case 'a': res *= 1e-18; break;
    case 'f': res *= 1e-15; break;
    case 'p': res *= 1e-12; break;
    case 'n': res *= 1e-9;  break;
    case 'u': res *= 1e-6;  break;
    case 'm': res *= 1e-3;  break;
    case 'k': res *= 1e3;   break;
    case 'M': res *= 1e6;   break;
    case 'G': res *= 1e9;   break;
    case 'T': res *= 1e12;  break;
    case 'P': res *= 1e15;  break;
    case 'E': res *= 1e18;  break;
    default: return false;
    }
    return true;
  }

  static double conv_double(const char *str, ::std::string &err, bool si_suffix) {
    char *endptr = 0;
    errno = 0;
    double res = strtod(str, &endptr);
    if(errno) {
      err.assign(strerror(errno));
      return (double)0.0;
    }
    bool invalid =
      si_suffix ? !adjust_double_si_suffix(res, endptr) : *endptr != '\0';
    if(invalid) {
      err.assign("Invalid character");
      return (double)0.0;
    }
    return res;
  }

  static int conv_enum(const char* str, ::std::string& err, const char* const strs[]) {
    int res = 0;
    for(const char* const* cstr = strs; *cstr; ++cstr, ++res)
      if(!strcmp(*cstr, str))
        return res;
    err += "Invalid constant '";
    err += str;
    err += "'. Expected one of { ";
    for(const char* const* cstr = strs; *cstr; ++cstr) {
      if(cstr != strs)
        err += ", ";
      err += *cstr;
    }
    err += " }";
    return -1;
  }

  template<typename T>
  static bool adjust_int_si_suffix(T &res, const char *suffix) {
    if(*suffix == '\0')
      return true;
    if(*(suffix + 1) != '\0')
      return false;

    switch(*suffix) {
    case 'k': res *= (T)1000; break;
    case 'M': res *= (T)1000000; break;
    case 'G': res *= (T)1000000000; break;
    case 'T': res *= (T)1000000000000; break;
    case 'P': res *= (T)1000000000000000; break;
    case 'E': res *= (T)1000000000000000000; break;
    default: return false;
    }
    return true;
  }

  template<typename T>
  static T conv_int(const char *str, ::std::string &err, bool si_suffix) {
    char *endptr = 0;
    errno = 0;
    long long int res = strtoll(str, &endptr, 0);
    if(errno) {
      err.assign(strerror(errno));
      return (T)0;
    }
    bool invalid =
      si_suffix ? !adjust_int_si_suffix(res, endptr) : *endptr != '\0';
    if(invalid) {
      err.assign("Invalid character");
      return (T)0;
    }
    if(res > ::std::numeric_limits<T>::max() ||
       res < ::std::numeric_limits<T>::min()) {
      err.assign("Value out of range");
      return (T)0;
    }
    return (T)res;
  }

  template<typename T>
  static T conv_uint(const char *str, ::std::string &err, bool si_suffix) {
    char *endptr = 0;
    errno = 0;
    while(isspace(*str)) { ++str; }
    if(*str == '-') {
      err.assign("Negative value");
      return (T)0;
    }
    unsigned long long int res = strtoull(str, &endptr, 0);
    if(errno) {
      err.assign(strerror(errno));
      return (T)0;
    }
    bool invalid =
      si_suffix ? !adjust_int_si_suffix(res, endptr) : *endptr != '\0';
    if(invalid) {
      err.assign("Invalid character");
      return (T)0;
    }
    if(res > ::std::numeric_limits<T>::max()) {
      err.assign("Value out of range");
      return (T)0;
    }
    return (T)res;
  }

  template<typename T>
  static ::std::string vec_str(const std::vector<T> &vec) {
    ::std::ostringstream os;
    for(typename ::std::vector<T>::const_iterator it = vec.begin();
        it != vec.end(); ++it) {
      if(it != vec.begin())
        os << ",";
      os << *it;
    }
    return os.str();
  }

  class string : public ::std::string {
  public:
    string() : ::std::string() {}
    explicit string(const ::std::string &s) : std::string(s) {}
    explicit string(const char *s) : ::std::string(s) {}
    int as_enum(const char* const strs[]) {
      ::std::string err;
      int res = conv_enum((const char*)this->c_str(), err, strs);
      if(!err.empty())
        throw ::std::runtime_error(err);
      return res;
    }


    uint32_t as_uint32_suffix() const { return as_uint32(true); }
    uint32_t as_uint32(bool si_suffix = false) const {
      ::std::string err;
      uint32_t res = conv_uint<uint32_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to uint32_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    uint64_t as_uint64_suffix() const { return as_uint64(true); }
    uint64_t as_uint64(bool si_suffix = false) const {
      ::std::string err;
      uint64_t res = conv_uint<uint64_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to uint64_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    int32_t as_int32_suffix() const { return as_int32(true); }
    int32_t as_int32(bool si_suffix = false) const {
      ::std::string err;
      int32_t res = conv_int<int32_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to int32_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    int64_t as_int64_suffix() const { return as_int64(true); }
    int64_t as_int64(bool si_suffix = false) const {
      ::std::string err;
      int64_t res = conv_int<int64_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to int64_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    int as_int_suffix() const { return as_int(true); }
    int as_int(bool si_suffix = false) const {
      ::std::string err;
      int res = conv_int<int>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to int_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    long as_long_suffix() const { return as_long(true); }
    long as_long(bool si_suffix = false) const {
      ::std::string err;
      long res = conv_int<long>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to long_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    double as_double_suffix() const { return as_double(true); }
    double as_double(bool si_suffix = false) const {
      ::std::string err;
      double res = conv_double((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to double_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
  };

public:
  const char *                   faux_reads_file_arg;
  bool                           faux_reads_file_given;
  const char *                   faux_read_matches_to_kunis_file_arg;
  bool                           faux_read_matches_to_kunis_file_given;
  const char *                   read_matches_to_kunis_file_arg;
  bool                           read_matches_to_kunis_file_given;
  ::std::vector<const char *>    reads_file_arg;
  typedef ::std::vector<const char *>::iterator reads_file_arg_it;
  typedef ::std::vector<const char *>::const_iterator reads_file_arg_const_it;
  bool                           reads_file_given;
  const char *                   dir_for_gaps_arg;
  bool                           dir_for_gaps_given;
  int                            num_joins_per_directory_arg;
  bool                           num_joins_per_directory_given;
  uint64_t                       max_reads_in_memory_arg;
  bool                           max_reads_in_memory_given;

  enum {
    START_OPT = 1000,
    FAUX_READS_FILE_OPT,
    FAUX_READ_MATCHES_TO_KUNIS_FILE_OPT,
    READ_MATCHES_TO_KUNIS_FILE_OPT,
    READS_FILE_OPT,
    DIR_FOR_GAPS_OPT,
    NUM_JOINS_PER_DIRECTORY_OPT,
    MAX_READS_IN_MEMORY_OPT
  };

  cmdline_parse() :
    faux_reads_file_arg(""), faux_reads_file_given(false),
    faux_read_matches_to_kunis_file_arg(""), faux_read_matches_to_kunis_file_given(false),
    read_matches_to_kunis_file_arg(""), read_matches_to_kunis_file_given(false),
    reads_file_arg(), reads_file_given(false),
    dir_for_gaps_arg("."), dir_for_gaps_given(false),
    num_joins_per_directory_arg((int)1), num_joins_per_directory_given(false),
    max_reads_in_memory_arg((uint64_t)100000000), max_reads_in_memory_given(false)
  { }

  cmdline_parse(int argc, char* argv[]) :
    faux_reads_file_arg(""), faux_reads_file_given(false),
    faux_read_matches_to_kunis_file_arg(""), faux_read_matches_to_kunis_file_given(false),
    read_matches_to_kunis_file_arg(""), read_matches_to_kunis_file_given(false),
    reads_file_arg(), reads_file_given(false),
    dir_for_gaps_arg("."), dir_for_gaps_given(false),
    num_joins_per_directory_arg((int)1), num_joins_per_directory_given(false),
    max_reads_in_memory_arg((uint64_t)100000000), max_reads_in_memory_given(false)
  { parse(argc, argv); }

  void parse(int argc, char* argv[]) {
    static struct option long_options[] = {
      {"faux-reads-file", 1, 0, FAUX_READS_FILE_OPT},
      {"faux-read-matches-to-kunis-file", 1, 0, FAUX_READ_MATCHES_TO_KUNIS_FILE_OPT},
      {"read-matches-to-kunis-file", 1, 0, READ_MATCHES_TO_KUNIS_FILE_OPT},
      {"reads-file", 1, 0, READS_FILE_OPT},
      {"dir-for-gaps", 1, 0, DIR_FOR_GAPS_OPT},
      {"num-joins-per-directory", 1, 0, NUM_JOINS_PER_DIRECTORY_OPT},
      {"max-reads-in-memory", 1, 0, MAX_READS_IN_MEMORY_OPT},
      {"help", 0, 0, 'h'},
      {"usage", 0, 0, 'U'},
      {"version", 0, 0, 'V'},
      {0, 0, 0, 0}
    };
    static const char *short_options = "hVU";

    ::std::string err;
#define CHECK_ERR(type,val,which) if(!err.empty()) { ::std::cerr << "Invalid " #type " '" << val << "' for [" which "]: " << err << "\n"; exit(1); }
    while(true) {
      int index = -1;
      int c = getopt_long(argc, argv, short_options, long_options, &index);
      if(c == -1) break;
      switch(c) {
      case ':':
        ::std::cerr << "Missing required argument for "
                  << (index == -1 ? ::std::string(1, (char)optopt) : std::string(long_options[index].name))
                  << ::std::endl;
        exit(1);
      case 'h':
        ::std::cout << usage() << "\n\n" << help() << std::endl;
        exit(0);
      case 'U':
        ::std::cout << usage() << "\nUse --help for more information." << std::endl;
        exit(0);
      case 'V':
        print_version();
        exit(0);
      case '?':
        ::std::cerr << "Use --usage or --help for some help\n";
        exit(1);
      case FAUX_READS_FILE_OPT:
        faux_reads_file_given = true;
        faux_reads_file_arg = optarg;
        break;
      case FAUX_READ_MATCHES_TO_KUNIS_FILE_OPT:
        faux_read_matches_to_kunis_file_given = true;
        faux_read_matches_to_kunis_file_arg = optarg;
        break;
      case READ_MATCHES_TO_KUNIS_FILE_OPT:
        read_matches_to_kunis_file_given = true;
        read_matches_to_kunis_file_arg = optarg;
        break;
      case READS_FILE_OPT:
        reads_file_given = true;
        reads_file_arg.push_back(optarg);
        break;
      case DIR_FOR_GAPS_OPT:
        dir_for_gaps_given = true;
        dir_for_gaps_arg = optarg;
        break;
      case NUM_JOINS_PER_DIRECTORY_OPT:
        num_joins_per_directory_given = true;
        num_joins_per_directory_arg = conv_int<int>((const char*)optarg, err, false);
        CHECK_ERR(int_t, optarg, "    --num-joins-per-directory=int")
        break;
      case MAX_READS_IN_MEMORY_OPT:
        max_reads_in_memory_given = true;
        max_reads_in_memory_arg = conv_uint<uint64_t>((const char*)optarg, err, false);
        CHECK_ERR(uint64_t, optarg, "    --max-reads-in-memory=uint64")
        break;
      }
    }

    // Check that required switches are present
    if(!faux_reads_file_given)
      error("[    --faux-reads-file=path] required switch");
    if(!faux_read_matches_to_kunis_file_given)
      error("[    --faux-read-matches-to-kunis-file=path] required switch");
    if(!read_matches_to_kunis_file_given)
      error("[    --read-matches-to-kunis-file=path] required switch");

    // Check at_least requirements
    if(reads_file_arg.size() < 1)
      error("[    --reads-file=path] must be given at least 1 times");

    // Parse arguments
    if(argc - optind != 0)
      error("Requires exactly 0 argument.");
  }
  static const char * usage() { return "Usage: cmdline_parse [options]"; }
  class error {
    int code_;
    std::ostringstream msg_;

    // Select the correct version (GNU or XSI) version of
    // strerror_r. strerror_ behaves like the GNU version of strerror_r,
    // regardless of which version is provided by the system.
    static const char* strerror__(char* buf, int res) {
      return res != -1 ? buf : "Invalid error";
    }
    static const char* strerror__(char* buf, char* res) {
      return res;
    }
    static const char* strerror_(int err, char* buf, size_t buflen) {
      return strerror__(buf, strerror_r(err, buf, buflen));
    }
    struct no_t { };

  public:
    static no_t no;
    error(int code = EXIT_FAILURE) : code_(code) { }
    explicit error(const char* msg, int code = EXIT_FAILURE) : code_(code)
      { msg_ << msg; }
    error(const std::string& msg, int code = EXIT_FAILURE) : code_(code)
      { msg_ << msg; }
    error& operator<<(no_t) {
      char buf[1024];
      msg_ << ": " << strerror_(errno, buf, sizeof(buf));
      return *this;
    }
    template<typename T>
    error& operator<<(const T& x) { msg_ << x; return (*this); }
    ~error() {
      ::std::cerr << "Error: " << msg_.str() << "\n"
                  << usage() << "\n"
                  << "Use --help for more information"
                  << ::std::endl;
      exit(code_);
    }
  };
  static const char * help() { return
    "Collect the reads we need for the local gap closing limited by available memory.\n\n\n\n"
    "Options (default value in (), *required):\n"
    "     --faux-reads-file=path              *Name of the faux reads file\n"
    "     --faux-read-matches-to-kunis-file=path\n                                         *Name of the file with matches from faux reads to k-unitigs\n"
    "     --read-matches-to-kunis-file=path   *Name of the file with matches from reads to k-unitigs\n"
    "     --reads-file=path                    Name of the reads file(s)\n"
    "     --dir-for-gaps=path                  Directory to use for files we keep for local gap closing (.)\n"
    "     --num-joins-per-directory=int        Number of joins put in each directory (1)\n"
    "     --max-reads-in-memory=uint64         Number of reads to hold in memory for gap closing bins (100000000)\n"
    " -U, --usage                              Usage\n"
    " -h, --help                               This message\n"
    " -V, --version                            Version";
  }
  static const char* hidden() { return ""; }
  void print_version(::std::ostream &os = std::cout) const {
#ifndef PACKAGE_VERSION
#define PACKAGE_VERSION "0.0.0"
#endif
    os << PACKAGE_VERSION << "\n";
  }
  void dump(::std::ostream &os = std::cout) {
    os << "faux_reads_file_given:" << faux_reads_file_given << " faux_reads_file_arg:" << faux_reads_file_arg << "\n";
    os << "faux_read_matches_to_kunis_file_given:" << faux_read_matches_to_kunis_file_given << " faux_read_matches_to_kunis_file_arg:" << faux_read_matches_to_kunis_file_arg << "\n";
    os << "read_matches_to_kunis_file_given:" << read_matches_to_kunis_file_given << " read_matches_to_kunis_file_arg:" << read_matches_to_kunis_file_arg << "\n";
    os << "reads_file_given:" << reads_file_given << " reads_file_arg:" << vec_str(reads_file_arg) << "\n";
    os << "dir_for_gaps_given:" << dir_for_gaps_given << " dir_for_gaps_arg:" << dir_for_gaps_arg << "\n";
    os << "num_joins_per_directory_given:" << num_joins_per_directory_given << " num_joins_per_directory_arg:" << num_joins_per_directory_arg << "\n";
    os << "max_reads_in_memory_given:" << max_reads_in_memory_given << " max_reads_in_memory_arg:" << max_reads_in_memory_arg << "\n";
  }
};
#endif // __CMDLINE_PARSE_HPP__"
