/***** This code was generated by Yaggo. Do not edit ******/

#ifndef __LONGEST_PATH_OVERLAP_GRAPH2_CMDLINE_HPP__
#define __LONGEST_PATH_OVERLAP_GRAPH2_CMDLINE_HPP__

#include <stdint.h>
#include <unistd.h>
#include <stdlib.h>
#include <getopt.h>
#include <errno.h>
#include <string.h>
#include <stdexcept>
#include <string>
#include <limits>
#include <vector>
#include <iostream>
#include <sstream>
#include <memory>

class longest_path_overlap_graph2_cmdline {
 // Boiler plate stuff. Conversion from string to other formats
  static bool adjust_double_si_suffix(double &res, const char *suffix) {
    if(*suffix == '\0')
      return true;
    if(*(suffix + 1) != '\0')
      return false;

    switch(*suffix) {
    case 'a': res *= 1e-18; break;
    case 'f': res *= 1e-15; break;
    case 'p': res *= 1e-12; break;
    case 'n': res *= 1e-9;  break;
    case 'u': res *= 1e-6;  break;
    case 'm': res *= 1e-3;  break;
    case 'k': res *= 1e3;   break;
    case 'M': res *= 1e6;   break;
    case 'G': res *= 1e9;   break;
    case 'T': res *= 1e12;  break;
    case 'P': res *= 1e15;  break;
    case 'E': res *= 1e18;  break;
    default: return false;
    }
    return true;
  }

  static double conv_double(const char *str, ::std::string &err, bool si_suffix) {
    char *endptr = 0;
    errno = 0;
    double res = strtod(str, &endptr);
    if(errno) {
      err.assign(strerror(errno));
      return (double)0.0;
    }
    bool invalid =
      si_suffix ? !adjust_double_si_suffix(res, endptr) : *endptr != '\0';
    if(invalid) {
      err.assign("Invalid character");
      return (double)0.0;
    }
    return res;
  }

  static int conv_enum(const char* str, ::std::string& err, const char* const strs[]) {
    int res = 0;
    for(const char* const* cstr = strs; *cstr; ++cstr, ++res)
      if(!strcmp(*cstr, str))
        return res;
    err += "Invalid constant '";
    err += str;
    err += "'. Expected one of { ";
    for(const char* const* cstr = strs; *cstr; ++cstr) {
      if(cstr != strs)
        err += ", ";
      err += *cstr;
    }
    err += " }";
    return -1;
  }

  template<typename T>
  static bool adjust_int_si_suffix(T &res, const char *suffix) {
    if(*suffix == '\0')
      return true;
    if(*(suffix + 1) != '\0')
      return false;

    switch(*suffix) {
    case 'k': res *= (T)1000; break;
    case 'M': res *= (T)1000000; break;
    case 'G': res *= (T)1000000000; break;
    case 'T': res *= (T)1000000000000; break;
    case 'P': res *= (T)1000000000000000; break;
    case 'E': res *= (T)1000000000000000000; break;
    default: return false;
    }
    return true;
  }

  template<typename T>
  static T conv_int(const char *str, ::std::string &err, bool si_suffix) {
    char *endptr = 0;
    errno = 0;
    long long int res = strtoll(str, &endptr, 0);
    if(errno) {
      err.assign(strerror(errno));
      return (T)0;
    }
    bool invalid =
      si_suffix ? !adjust_int_si_suffix(res, endptr) : *endptr != '\0';
    if(invalid) {
      err.assign("Invalid character");
      return (T)0;
    }
    if(res > ::std::numeric_limits<T>::max() ||
       res < ::std::numeric_limits<T>::min()) {
      err.assign("Value out of range");
      return (T)0;
    }
    return (T)res;
  }

  template<typename T>
  static T conv_uint(const char *str, ::std::string &err, bool si_suffix) {
    char *endptr = 0;
    errno = 0;
    while(isspace(*str)) { ++str; }
    if(*str == '-') {
      err.assign("Negative value");
      return (T)0;
    }
    unsigned long long int res = strtoull(str, &endptr, 0);
    if(errno) {
      err.assign(strerror(errno));
      return (T)0;
    }
    bool invalid =
      si_suffix ? !adjust_int_si_suffix(res, endptr) : *endptr != '\0';
    if(invalid) {
      err.assign("Invalid character");
      return (T)0;
    }
    if(res > ::std::numeric_limits<T>::max()) {
      err.assign("Value out of range");
      return (T)0;
    }
    return (T)res;
  }

  template<typename T>
  static ::std::string vec_str(const std::vector<T> &vec) {
    ::std::ostringstream os;
    for(typename ::std::vector<T>::const_iterator it = vec.begin();
        it != vec.end(); ++it) {
      if(it != vec.begin())
        os << ",";
      os << *it;
    }
    return os.str();
  }

  class string : public ::std::string {
  public:
    string() : ::std::string() {}
    explicit string(const ::std::string &s) : std::string(s) {}
    explicit string(const char *s) : ::std::string(s) {}
    int as_enum(const char* const strs[]) {
      ::std::string err;
      int res = conv_enum((const char*)this->c_str(), err, strs);
      if(!err.empty())
        throw ::std::runtime_error(err);
      return res;
    }


    uint32_t as_uint32_suffix() const { return as_uint32(true); }
    uint32_t as_uint32(bool si_suffix = false) const {
      ::std::string err;
      uint32_t res = conv_uint<uint32_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to uint32_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    uint64_t as_uint64_suffix() const { return as_uint64(true); }
    uint64_t as_uint64(bool si_suffix = false) const {
      ::std::string err;
      uint64_t res = conv_uint<uint64_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to uint64_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    int32_t as_int32_suffix() const { return as_int32(true); }
    int32_t as_int32(bool si_suffix = false) const {
      ::std::string err;
      int32_t res = conv_int<int32_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to int32_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    int64_t as_int64_suffix() const { return as_int64(true); }
    int64_t as_int64(bool si_suffix = false) const {
      ::std::string err;
      int64_t res = conv_int<int64_t>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to int64_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    int as_int_suffix() const { return as_int(true); }
    int as_int(bool si_suffix = false) const {
      ::std::string err;
      int res = conv_int<int>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to int_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    long as_long_suffix() const { return as_long(true); }
    long as_long(bool si_suffix = false) const {
      ::std::string err;
      long res = conv_int<long>((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to long_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
    double as_double_suffix() const { return as_double(true); }
    double as_double(bool si_suffix = false) const {
      ::std::string err;
      double res = conv_double((const char*)this->c_str(), err, si_suffix);
      if(!err.empty()) {
        ::std::string msg("Invalid conversion of '");
        msg += *this;
        msg += "' to double_t: ";
        msg += err;
        throw ::std::runtime_error(msg);
      }
      return res;
    }
  };

public:
  struct tiling {
    enum { none, greedy, maximal };
    static const char* const  strs[4];
  };
  struct trim {
    enum { none, match, branch };
    static const char* const  strs[4];
  };

  uint32_t                       threads_arg;
  bool                           threads_given;
  const char *                   output_arg;
  bool                           output_given;
  const char *                   dot_arg;
  bool                           dot_given;
  double                         overlap_play_arg;
  bool                           overlap_play_given;
  double                         errors_arg;
  bool                           errors_given;
  bool                           bases_flag;
  const char *                   unitigs_lengths_arg;
  bool                           unitigs_lengths_given;
  const char *                   unitigs_sequences_arg;
  bool                           unitigs_sequences_given;
  uint32_t                       k_mer_arg;
  bool                           k_mer_given;
  double                         density_arg;
  bool                           density_given;
  double                         min_length_arg;
  bool                           min_length_given;
  int                            tiling_arg;
  bool                           tiling_given;
  int                            trim_arg;
  bool                           trim_given;
  const char *                   coords_arg;

  enum {
    START_OPT = 1000,
    DOT_OPT,
    TRIM_OPT
  };

  longest_path_overlap_graph2_cmdline() :
    threads_arg((uint32_t)1), threads_given(false),
    output_arg(""), output_given(false),
    dot_arg(""), dot_given(false),
    overlap_play_arg((double)1.3), overlap_play_given(false),
    errors_arg((double)3.0), errors_given(false),
    bases_flag(false),
    unitigs_lengths_arg(""), unitigs_lengths_given(false),
    unitigs_sequences_arg(""), unitigs_sequences_given(false),
    k_mer_arg(0), k_mer_given(false),
    density_arg((double)0.05), density_given(false),
    min_length_arg((double)100.0), min_length_given(false),
    tiling_arg(1), tiling_given(false),
    trim_arg(0), trim_given(false),
    coords_arg("")
  { }

  longest_path_overlap_graph2_cmdline(int argc, char* argv[]) :
    threads_arg((uint32_t)1), threads_given(false),
    output_arg(""), output_given(false),
    dot_arg(""), dot_given(false),
    overlap_play_arg((double)1.3), overlap_play_given(false),
    errors_arg((double)3.0), errors_given(false),
    bases_flag(false),
    unitigs_lengths_arg(""), unitigs_lengths_given(false),
    unitigs_sequences_arg(""), unitigs_sequences_given(false),
    k_mer_arg(0), k_mer_given(false),
    density_arg((double)0.05), density_given(false),
    min_length_arg((double)100.0), min_length_given(false),
    tiling_arg(1), tiling_given(false),
    trim_arg(0), trim_given(false),
    coords_arg("")
  { parse(argc, argv); }

  void parse(int argc, char* argv[]) {
    static struct option long_options[] = {
      {"threads", 1, 0, 't'},
      {"output", 1, 0, 'o'},
      {"dot", 1, 0, DOT_OPT},
      {"overlap-play", 1, 0, 'O'},
      {"errors", 1, 0, 'e'},
      {"bases", 0, 0, 'b'},
      {"unitigs-lengths", 1, 0, 'l'},
      {"unitigs-sequences", 1, 0, 'u'},
      {"k-mer", 1, 0, 'k'},
      {"density", 1, 0, 'd'},
      {"min-length", 1, 0, 'L'},
      {"tiling", 1, 0, 'T'},
      {"trim", 1, 0, TRIM_OPT},
      {"help", 0, 0, 'h'},
      {"usage", 0, 0, 'U'},
      {"version", 0, 0, 'V'},
      {0, 0, 0, 0}
    };
    static const char *short_options = "hVUt:o:O:e:bl:u:k:d:L:T:";

    ::std::string err;
#define CHECK_ERR(type,val,which) if(!err.empty()) { ::std::cerr << "Invalid " #type " '" << val << "' for [" which "]: " << err << "\n"; exit(1); }
    while(true) {
      int index = -1;
      int c = getopt_long(argc, argv, short_options, long_options, &index);
      if(c == -1) break;
      switch(c) {
      case ':':
        ::std::cerr << "Missing required argument for "
                  << (index == -1 ? ::std::string(1, (char)optopt) : std::string(long_options[index].name))
                  << ::std::endl;
        exit(1);
      case 'h':
        ::std::cout << usage() << "\n\n" << help() << std::endl;
        exit(0);
      case 'U':
        ::std::cout << usage() << "\nUse --help for more information." << std::endl;
        exit(0);
      case 'V':
        print_version();
        exit(0);
      case '?':
        ::std::cerr << "Use --usage or --help for some help\n";
        exit(1);
      case 't':
        threads_given = true;
        threads_arg = conv_uint<uint32_t>((const char*)optarg, err, false);
        CHECK_ERR(uint32_t, optarg, "-t, --threads=uint32")
        break;
      case 'o':
        output_given = true;
        output_arg = optarg;
        break;
      case DOT_OPT:
        dot_given = true;
        dot_arg = optarg;
        break;
      case 'O':
        overlap_play_given = true;
        overlap_play_arg = conv_double((const char*)optarg, err, false);
        CHECK_ERR(double_t, optarg, "-O, --overlap-play=double")
        break;
      case 'e':
        errors_given = true;
        errors_arg = conv_double((const char*)optarg, err, false);
        CHECK_ERR(double_t, optarg, "-e, --errors=double")
        break;
      case 'b':
        bases_flag = true;
        break;
      case 'l':
        unitigs_lengths_given = true;
        unitigs_lengths_arg = optarg;
        break;
      case 'u':
        unitigs_sequences_given = true;
        unitigs_sequences_arg = optarg;
        break;
      case 'k':
        k_mer_given = true;
        k_mer_arg = conv_uint<uint32_t>((const char*)optarg, err, false);
        CHECK_ERR(uint32_t, optarg, "-k, --k-mer=uint32")
        break;
      case 'd':
        density_given = true;
        density_arg = conv_double((const char*)optarg, err, false);
        CHECK_ERR(double_t, optarg, "-d, --density=double")
        break;
      case 'L':
        min_length_given = true;
        min_length_arg = conv_double((const char*)optarg, err, false);
        CHECK_ERR(double_t, optarg, "-L, --min-length=double")
        break;
      case 'T':
        tiling_given = true;
        tiling_arg = conv_enum((const char*)optarg, err, tiling::strs);
        CHECK_ERR(enum, optarg, "-T, --tiling=none|greedy|maximal")
        break;
      case TRIM_OPT:
        trim_given = true;
        trim_arg = conv_enum((const char*)optarg, err, trim::strs);
        CHECK_ERR(enum, optarg, "    --trim=none|match|branch")
        break;
      }
    }

    // Check that required switches are present
    if(!k_mer_given)
      error("[-k, --k-mer=uint32] required switch");

    // Check mutually exlusive switches
    if(unitigs_sequences_given && unitigs_lengths_given)
      error("Switches [-u, --unitigs-sequences=path] and [-l, --unitigs-lengths=path] are mutually exclusive");

    // Parse arguments
    if(argc - optind != 1)
      error("Requires exactly 1 argument.");
    coords_arg = argv[optind];
    ++optind;
  }
  static const char * usage() { return "Usage: longest_path_overlap_graph2_cmdline [options] coords:path"; }
  class error {
    int code_;
    std::ostringstream msg_;

    // Select the correct version (GNU or XSI) version of
    // strerror_r. strerror_ behaves like the GNU version of strerror_r,
    // regardless of which version is provided by the system.
    static const char* strerror__(char* buf, int res) {
      return res != -1 ? buf : "Invalid error";
    }
    static const char* strerror__(char* buf, char* res) {
      return res;
    }
    static const char* strerror_(int err, char* buf, size_t buflen) {
      return strerror__(buf, strerror_r(err, buf, buflen));
    }
    struct no_t { };

  public:
    static no_t no;
    error(int code = EXIT_FAILURE) : code_(code) { }
    explicit error(const char* msg, int code = EXIT_FAILURE) : code_(code)
      { msg_ << msg; }
    error(const std::string& msg, int code = EXIT_FAILURE) : code_(code)
      { msg_ << msg; }
    error& operator<<(no_t) {
      char buf[1024];
      msg_ << ": " << strerror_(errno, buf, sizeof(buf));
      return *this;
    }
    template<typename T>
    error& operator<<(const T& x) { msg_ << x; return (*this); }
    ~error() {
      ::std::cerr << "Error: " << msg_.str() << "\n"
                  << usage() << "\n"
                  << "Use --help for more information"
                  << ::std::endl;
      exit(code_);
    }
  };
  static const char * help() { return
    "Find the longest path in the super-read overlap graph\n\n"
    "Options (default value in (), *required):\n"
    " -t, --threads=uint32                     Number of threads (1)\n"
    " -o, --output=path                        Output file\n"
    "     --dot=path                           Write an overlap graph (dot file)\n"
    " -O, --overlap-play=double                Play in overlap length between position and k-unitig lengths (1.3)\n"
    " -e, --errors=double                      Number of average errors slack for overlap computation (3.0)\n"
    " -b, --bases                              Maximize number of bases in path, not the number of mers (false)\n"
    " -l, --unitigs-lengths=path               Length of k-unitigs\n"
    " -u, --unitigs-sequences=path             Fasta file containing the sequence of the k-unitigs\n"
    " -k, --k-mer=uint32                      *Length of k-mer used to create k-unitigs\n"
    " -d, --density=double                     Minimum density of k-mers (0.05)\n"
    " -L, --min-length=double                  Minimum length of a mega-read (100.0)\n"
    " -T, --tiling=none|greedy|maximal         Option for tiling mega-reads (greedy)\n"
    "     --trim=none|match|branch             How to trim mega-read (none)\n"
    " -U, --usage                              Usage\n"
    " -h, --help                               This message\n"
    " -V, --version                            Version";
  }
  static const char* hidden() { return ""; }
  void print_version(::std::ostream &os = std::cout) const {
#ifndef PACKAGE_VERSION
#define PACKAGE_VERSION "0.0.0"
#endif
    os << PACKAGE_VERSION << "\n";
  }
  void dump(::std::ostream &os = std::cout) {
    os << "threads_given:" << threads_given << " threads_arg:" << threads_arg << "\n";
    os << "output_given:" << output_given << " output_arg:" << output_arg << "\n";
    os << "dot_given:" << dot_given << " dot_arg:" << dot_arg << "\n";
    os << "overlap_play_given:" << overlap_play_given << " overlap_play_arg:" << overlap_play_arg << "\n";
    os << "errors_given:" << errors_given << " errors_arg:" << errors_arg << "\n";
    os << "bases_flag:" << bases_flag << "\n";
    os << "unitigs_lengths_given:" << unitigs_lengths_given << " unitigs_lengths_arg:" << unitigs_lengths_arg << "\n";
    os << "unitigs_sequences_given:" << unitigs_sequences_given << " unitigs_sequences_arg:" << unitigs_sequences_arg << "\n";
    os << "k_mer_given:" << k_mer_given << " k_mer_arg:" << k_mer_arg << "\n";
    os << "density_given:" << density_given << " density_arg:" << density_arg << "\n";
    os << "min_length_given:" << min_length_given << " min_length_arg:" << min_length_arg << "\n";
    os << "tiling_given:" << tiling_given << " tiling_arg:" << tiling_arg << "|" << tiling::strs[tiling_arg] << "\n";
    os << "trim_given:" << trim_given << " trim_arg:" << trim_arg << "|" << trim::strs[trim_arg] << "\n";
    os << "coords_arg:" << coords_arg << "\n";
  }
};
const char* const longest_path_overlap_graph2_cmdline::tiling::strs[4] = { "none", "greedy", "maximal", (const char*)0 };
const char* const longest_path_overlap_graph2_cmdline::trim::strs[4] = { "none", "match", "branch", (const char*)0 };
#endif // __LONGEST_PATH_OVERLAP_GRAPH2_CMDLINE_HPP__"
