
/**************************************************************************
 * This file is part of Celera Assembler, a software program that
 * assembles whole-genome shotgun reads into contigs and scaffolds.
 * Copyright (C) 2007, J. Craig Venter Institute.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received (LICENSE.txt) a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *************************************************************************/

#ifndef AS_UTL_IID_H
#define AS_UTL_IID_H

static const char *rcsid_AS_UTL_IID_H = "$Id: AS_UTL_IID.H 4371 2013-08-01 17:19:47Z brianwalenz $";

typedef int32  CDS_CID_t;
#define F_CID           F_S32
#define F_CIDP          F_S32P

typedef uint32 AS_IID;
#define AS_IID_MAX      UINT32_MAX
#define F_IID           F_U32
#define F_IIDP          F_U32P

static
inline
AS_IID
AS_IID_fromString(const char *str, const char *&nxt) {
  return(strtoull(str, (char**)&nxt, 10));
}
static
inline
AS_IID
AS_IID_fromString(const char* str) {
  return(strtoull(str, NULL, 10));
}

static
inline
int
AS_IID_isDefined(AS_IID iid) {
  return(iid > 0);
}


#endif  //  AS_UTL_IID_H
