
/**************************************************************************
 * This file is part of Celera Assembler, a software program that
 * assembles whole-genome shotgun reads into contigs and scaffolds.
 * Copyright (C) 1999-2004, Applera Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received (LICENSE.txt) a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *************************************************************************/
/*************************************************
* Module:  ShowCorrectsOVL.c
* Description:
*   Based on overlaps between DNA fragment sequences, make corrections
*   to single bases in the sequences.
*
*    Programmer:  A. Delcher
*       Started:   11 Dec 2000
*
* Assumptions:
*
* Notes:
*
*************************************************/

/* RCS info
 * $Id: ShowCorrectsOVL.C 4371 2013-08-01 17:19:47Z brianwalenz $
 * $Revision: 1.14 $
*/

static const char *rcsid = "$Id: ShowCorrectsOVL.C 4371 2013-08-01 17:19:47Z brianwalenz $";


//  System include files

#include  <stdlib.h>
#include  <stdio.h>
#include  <assert.h>
#include  <fcntl.h>
#include  <string.h>
#include  <unistd.h>


//  Local include files

#include  "AS_OVL_delcher.H"
#include  "AS_PER_gkpStore.H"
#include  "AS_PER_genericStore.H"
#include  "AS_MSG_pmesg.H"
#include  "FragCorrectOVL.H"



//  Type definitions



//  Static Functions

static void  Usage
    (char * command);



int  main
    (int argc, char * argv [])

  {
   FILE  * fp;
   Correction_Output_t  msg;

   if  (argc < 2)
       {
        Usage (argv [0]);
        exit (1);
       }

   fp = File_Open (argv [1], "rb");

   while  (fread (& msg, sizeof (Correction_Output_t), 1, fp) == 1)
     {
      if  (msg . frag . is_ID)
          printf (">%8u  %s  %s\n",
                  msg . frag . iid,
                  msg . frag . keep_left ? "KL" : "  ",
                  msg . frag . keep_right ? "KR" : "  ");
        else
          {
           printf (" %4" F_U64P" ", msg . corr . pos);
           switch  ((Vote_Value_t) msg . corr . type)
             {
              case  EXTENSION :
                printf ("extend\n");
                break;
              case  DELETE :
                printf ("d\n");
                break;
              case  A_SUBST :
                printf ("x a\n");
                break;
              case  C_SUBST :
                printf ("x c\n");
                break;
              case  G_SUBST :
                printf ("x g\n");
                break;
              case  T_SUBST :
                printf ("x t\n");
                break;
              case  A_INSERT :
                printf ("i a\n");
                break;
              case  C_INSERT :
                printf ("i c\n");
                break;
              case  G_INSERT :
                printf ("i g\n");
                break;
              case  T_INSERT :
                printf ("i t\n");
                break;
              default :
                fprintf (stderr, "ERROR:  Bad correction type = %d\n",
                         (int) msg . corr . type);
             }
          }
     }

   fclose (fp);

   return  0;
  }



static void  Usage
    (char * command)

//  Print to stderr description of options and command line for
//  this program.   command  is the command that was used to
//  invoke it.

  {
   fprintf (stderr,
           "USAGE:  %s <filename>\n"
           "\n"
           "Dump ASCII version of fragment corrections listed in\n"
           " <filename>  to stdout\n"
           "\n"
           "Options:\n",
           command);

   return;
  }



