library(pheatmap)

Human <- read.table("DEGs.fpkm.morethan1.0.samples2.log10.var0.05.order.txt",header=T,row.names=1) # Human expression data
Monkey <- read.table("FDR.0.0001.DEGs.cal.FPKM.Log.txt",header=T,row.names=1) # monkey expression data
Mouse <- read.table("Mouse.DEGs.fpkm.morethan1.0.samples2.log10.var0.05.order.txt",header=T,row.names=1) # mouse expression data

########################################### processing the data of human
MeanHuman <- function(x)
  {
  x <- as.numeric(x)
  return (c(mean(x[1:3]),mean(x[4:6]),mean(x[9:11]),mean(x[12:15]),mean(x[16:25]),mean(x[26:28])))
}

HumanMerge <- t(apply(Human,1,MeanHuman))

HumanMergeCor <- cor(HumanMerge)

pheatmap(HumanMergeCor,cluster_cols=F,cluster_rows=F)

########################################### processing the data of monkey
MeanMonkey <- function(x)
{
  x <- as.numeric(x)
  return (c(mean(x[4:6]),mean(x[7:9]),mean(x[10:12]),mean(x[13:14]),mean(x[15:19]),mean(x[20:22])))
}

MonkeyMerge <- t(apply(Monkey,1,MeanMonkey))

MonkeyMergeCor <- cor(MonkeyMerge)

pheatmap(MonkeyMergeCor,cluster_cols=F,cluster_rows=F)


###################################### processing the data of mouse
MeanMouse <- function(x)
{
  x <- as.numeric(x)
  return (c(mean(x[1:2]),mean(x[3:5]),mean(x[6:8]),mean(x[9:11]),mean(x[12:14]),mean(x[15:17])))
}

MouseMerge <- t(apply(Mouse,1,MeanMouse))

MouseMergeCor <- cor(MouseMerge)

pheatmap(MouseMergeCor,cluster_cols=F,cluster_rows=F)

######################################## MergeThree
CalCor <- function(a,b)
{
  cors <- c()
  for (i in 1:6)
  {
    for (j in 1:6)
    { cors <- c(cors,cor(a[i,],b[j,]))}
  }
  cors <- matrix(cors,nrow=6)
  rownames(cors) <- c("MII","PN","2C","4C","8C","MOR")
  colnames(cors) <- c("MII","PN","2C","4C","8C","MOR")
  return (cors)
}

################# Human Monkey correlation
HumanMonkey <- CalCor(HumanMergeCor,MonkeyMergeCor)
pdf("Human.Monkey.Cor.Hierarchica.pdf",width=6,height=6)
pheatmap(HumanMonkey,cluster_cols=T,cluster_rows=T,breaks=seq(-1,1,length=101))
dev.off()

################# Human Mouse correlation
HumanMouse <- CalCor(HumanMergeCor,MouseMergeCor)
pdf("Human.Mouse.Cor.Hierarchical.pdf",width=6,height=6)
pheatmap(HumanMouse,cluster_cols=T,cluster_rows=T,breaks=seq(-1,1,length=101))
dev.off()
################### Monkey Mouse correlation
MonkeyMouse <- CalCor(MonkeyMergeCor,MouseMergeCor)
pdf("Monkey.Mouse.Cor.Hierarchical.pdf",width=6,height=6)
pheatmap(MonkeyMouse,cluster_cols=T,cluster_rows=T,breaks=seq(-1,1,length=101))
dev.off()
##################