# normalization reads counts by DESeq2
library(DESeq2)
RawCounts <- read.table("RawCounts.All.txt",header=T,row.names=1)

#filter lowly expressed genes
filter <- apply(RawCounts, 1, function(x) length(x[x>10])>=2)
filtered <- RawCounts[filter,]
dim(filter)

condition <- c(rep(c("GV", "MII","PN","2C"),each=3),"4C","4C",rep("8C",5),rep(c("Morula","Blast"), each=3),"Blast")
celldesign <- data.frame(row.names=colnames(RawCounts),condition=condition)

dds <- DESeqDataSetFromMatrix(countData = RawCounts,colData = celldesign,design= ~ condition)
dds <- DESeq(dds)

NormalizedCounts <- counts(dds,normalized=TRUE)
write.table(NormalizedCounts,"NormalizedCounts.DESeq2.txt",quote=F,sep="\t")

####################################################################### sva for removing batch effects
library(FactoMineR)

res.pca <- PCA(t(log(NormalizedCounts+1)),ncp=2,graph=TRUE,scale.unit=T,axes=c(1,2))
library(sva)
SampleName <- colnames(NormalizedCounts)
batch <- c(rep("Batch1",17),rep("Batch2",2),rep("Batch1",7))
pheno <- data.frame(SampleName,batch)
modcombat = model.matrix(~1, data=pheno)
combat_edata = ComBat(dat=(NormalizedCounts), batch=batch, mod=modcombat, par.prior=TRUE, prior.plots=FALSE)

res.pca <- PCA(t(combat_edata),ncp=2,graph=TRUE,scale.unit=T,axes=c(1,2))
write.table(combat_edata,"NormalizedCounts.DESeq2.FPKM.combat.txt",sep="\t",quote=F)

## PCA
library("FactoMineR")
#res.pca <- PCA(t(log10(NormalizedCounts+1)),ncp=2,graph=TRUE,scale.unit=T,axes=c(1,2))
PCA.Value <- res.pca$ind$coord
SampleName <- colnames(NormalizedCounts)
cexSize=1.5
cexFont = 1
pdf("PCA.Normalization.Name.pdf",height=6,width=6)
plot(PCA.Value[1:3,],xlim=c(-80,150),ylim=c(-110,65),cex=cexSize,pch=17,col="deepskyblue2",xlab="PC1(35.93%)",ylab="PC2(14.21%)")
text(PCA.Value[1:3,],SampleName[1:3],cex=cexFont,pos=4,col="deepskyblue2")

points(PCA.Value[4:6,],pch=17,col="darkorchid1",cex=cexSize)
text(PCA.Value[4:6,],SampleName[4:6],cex=cexFont,pos=4,col="darkorchid1")

points(PCA.Value[7:9,],pch=17,col="gold4",cex=cexSize)
text(PCA.Value[7:9,],SampleName[7:9],cex=cexFont,pos=4,col="gold4")


points(PCA.Value[10:12,],pch=17,cex=cexSize,col="chartreuse4")
text(PCA.Value[10:12,],SampleName[10:12],cex=cexFont,pos=2,col="chartreuse4")

points(PCA.Value[13:14,],pch=17,col = "goldenrod1",cex=cexSize)
text(PCA.Value[13:14,],SampleName[13:14],cex=cexFont,pos=4,col="goldenrod1")

points(PCA.Value[15:19,],pch=16,col="darkorchid4",cex=cexSize)
text(PCA.Value[15:19,],SampleName[15:19],cex=cexFont,pos=4,col="darkorchid4")

points(PCA.Value[20:22,],pch=16,col="darkorange2",cex=cexSize)
text(PCA.Value[20:22,],SampleName[20:22],cex=cexFont,pos=1,col="darkorange2")

points(PCA.Value[23:26,],pch=16,col="orangered2",cex=cexSize)
text(PCA.Value[23:26,],SampleName[23:26],cex=cexFont,pos=3,col="orangered2")

legend("bottomright",c("GV","MII","PN","2C","4C","8C","Morula","Blast"),pch=c(rep(17,8)),
       col=c("deepskyblue2","darkorchid1","gold4","chartreuse4","goldenrod1","darkorchid4","darkorange2","orangered2"),inset=0.01,cex=1.1)
dev.off()



############################################################################## DEGs by DESeq2
dir.create("2.DEGs")
setwd(".//2.DEGs")
CalSigGene <- function(dds,Con1,Con2,FDR)
{
  res <- results(dds,contrast=c("condition",Con1,Con2))
  resOrder <- res[order(res$padj),]
  #sum(res$padj < FDR,na.rm=T)
  resSig <- subset(resOrder,padj < FDR)
  resSigUp <- subset(resSig,log2FoldChange <0)
  resSigDown <- subset(resSig,log2FoldChange >0)
  outFileUp <- paste(Con1,"-",Con2,".Up.txt",sep="")
  write.table(resSigUp,outFileUp,sep="\t",quote=F)
  outFileDown <- paste(Con1,"-",Con2,".Down.txt",sep="")
  write.table(resSigDown,outFileDown,sep="\t",quote=F)
  
}

stage <- c("GV","MII","PN","2C","4C","8C","Morula","Blast")
stageCombn <- combn(stage,2)



# FDR 0.00001
FDR=0.00001
NewFile = paste("FDR",".",FDR,sep="")
dir.create(NewFile)
setwd(NewFile)
for (i in 1:ncol(stageCombn))
{
  CalSigGene(dds,stageCombn[,i][1],stageCombn[,i][2],FDR)
}

