#!/usr/bin/env python
#Author: Duy Tin Truong (duytin.truong@unitn.it)
#        at CIBIO, University of Trento, Italy

__author__  = 'Duy Tin Truong (duytin.truong@unitn.it)'
__version__ = '0.1'
__date__    = '31 Oct 2016'

import sys
import os
import argparse 
import glob


class MySolution(object):
    def __init__(self):
        pass

    def read_params(self):
        p = argparse.ArgumentParser()
        p.add_argument(
            '--input_dirs', 
            required=True,
            nargs='+',
            default=[], 
            type=str,
            help='first arg')
        p.add_argument(
            '--ofn', 
            required=True,
            type=str,
            help='first arg')
        p.add_argument(
            '--verbose', 
            required=False, 
            dest='quiet',
            action='store_false',
            help='Show all information. Default "not set".')
        p.set_defaults(quiet=True)

        return p.parse_args()


    def main(self):
        args = self.read_params()
        with open(args.ofn, 'w') as ofile:
            ofile.write('sampleID\tdataset\n')
            for idir in args.input_dirs:
                dataset = os.path.basename(idir)
                ifn_config = os.path.join(idir, 'config.txt')
                with open(ifn_config, 'r') as ifile:
                    for line in ifile:
                        if line.startswith('file_ext = ') or \
                            line.startswith('file_ext_1'):
                            file_ext = line.split('=')[1].strip()
                ifns = glob.glob('%s/*%s'%(idir, file_ext))
                for ifn in ifns:
                    sample = os.path.basename(ifn).replace(file_ext, '')
                    ofile.write('%s\t%s\n'%(sample, dataset))



if __name__ == "__main__":
    mysol = MySolution()
    mysol.main()
