#!/usr/bin/python

# Script to identify the main summit within a peak (working with Python 2.7.5).
# Required modules and functions = csv, re, sys and BigWigFile.
# Usage : python Supplemental_File_S1.py -BigWigFile ChIP_seq.bw -enhancers peaks.bed
# 	ChIP_seq.bw = bw file generated using a normalized WIG file (i.e. the WIG file generated by SICER using the reads kept after filtering out redundant reads).
# 	peaks.bed = BED file containing the coordinates of the significant peaks identified by a peak caller (e.g. SICER).

# Import modules.
from bx.bbi.bigwig_file import BigWigFile
import csv
import re
import sys

# Read parameters.
argv = sys.argv[1:]
while argv:
	argument = argv.pop(0)
	if(re.match('^-BigWigFile', argument)):
		bw_file = argv.pop(0)
	elif(re.match('^-enhancers', argument)):
		enhancer_list = argv.pop(0)

# Load BigWig file and peak coordinates.
f = open(bw_file)
bw = BigWigFile(file=f)

enhancer_f = open(enhancer_list, 'rb')
data = csv.reader(enhancer_f, delimiter='\t')
enhancer_tab = [row for row in data]

# Create matrix to store summit positions.
summits = [[0 for x in xrange(3)] for x in xrange(len(enhancer_tab))]

# Get the summit for each peak and save the coordinates.
for i in range(0,len(enhancer_tab)):
	vals = bw.get(enhancer_tab[i][0], int(enhancer_tab[i][1]), int(enhancer_tab[i][2]))
	max_start, max_end, max_val = max(vals, key = lambda x: x[-1])
	summits[i][0] = enhancer_tab[i][0]
	summits[i][1] = max_start
	summits[i][2] = max_end

# Write bed file with summit coordinates.
print "\n".join("\t".join(str(col) for col in row) for row in summits)

enhancer_f.close()
f.close()

