setwd("/home/pamjat/Sonya");
data<-read.table(file="results/ups_zeta_lagging_VC",sep=" ")

coef1<-100#(1/data$V3[12])

conf_timing<-binconf( data$V4[1:8], data$V5[1:8])
lower_timing<-conf_timing[,2]*coef1
upper_timing<-conf_timing[,3]*coef1

ggplot(data,aes(x=V2,y=V3*coef1,fill=V1))+#geom_bar()
  geom_bar(colour="black",position=position_dodge(.9),stat="identity")+
  scale_fill_discrete(name="")+#,values=c("#c1ffc1","#eed8ae")) + 
  ylab(bquote('SNP density*10'^4))+xlab('mutation type') +
  #ylab("SNP density") + xlab('') +
  theme_bw()+
  theme( axis.title=element_text(size=15))+
  theme(title=element_text(size=12))+theme( axis.text.y=element_text(size=10),axis.text.x=element_text(size=10))+
  geom_errorbar(aes(ymin=lower_timing, ymax=upper_timing),position=position_dodge(.9), width=.2)+
  ggtitle("lagging strand")+#ggtitle(expression(r[apo]<2))+
  theme(legend.text = element_text(size = 14),legend.title = element_text( size=14, face="bold"))



