require(lattice)
setwd("/home/pamjat/Sonya/sites_for_all/asymm/");

axis.set=function(side,...){
  if(side == "right"){
    panel.axis(side=side, draw.labels=T,outside=T, check.overlap = F,
               #                   labels=c("C>T","C>T","C>T","C>T","C>A","C>A","C>A","C>A","C>G","C>G","C>G","C>G","T>C","T>C","T>C","T>C","T>A","T>A","T>A","T>A","T>G","T>G","T>G","T>G"),
               labels = c("C>T","C>A","C>G","T>C","T>A","T>G"),
               rot=0, tck=0,at=c(22.5,18.5,14.5,10.5,6.5,2.5))
    panel.axis(side=side, outside=TRUE, at=c(4.5,8.5,12.5,16.5,20.5),  tck=3.5,draw.labels=F)
  }else{
    if(side == "left"){
                panel.axis(side=side,labels = c("G","A","C","T","G","A","C","T","G","A","C","T","G","A","C","T","G","A","C","T","G","A","C","T"),outside=T,draw.labels=T, check.overlap=F,
                 at=c(24,23,22,21,20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1))}             
    
    else axis.default(side=side, ...)
  } }

tables = list.files(path = ".", pattern = "norm_rec_1_rare_mashaf")
print(tables)

for (i in 1:1){
  name ="summ_int_NA_sing_mashaf"#tables[i]
  print(name)
  outname = strsplit(name,"_for")[[1]][1]
  outname = paste("../../R_figure/",outname,".jpg",sep="")
  print(outname)  
  dano=read.table(name,header=T)
  dano = dano[2:ncol(dano)]
  dano = as.matrix(dano)
  dano = t(dano)
  jpeg(outname, res = 500, width = 5, height = 5, units = 'in')
  rgb.palette <- colorRampPalette(c("darkblue", "white", "red"), space = "Lab")
  plot(levelplot(dano, xlab=NULL, ylab=NULL, axis=axis.set,col.regions = rgb.palette(1000), 
                 at=seq(-0.35, 0.35, length=1001),colorkey = list(space="left")))
  dev.off()  
  
}