require(lattice)
setwd("/home/pamjat/Sonya/sites_for_all/rate/");
axis.set=function(side,...){
  if(side == "right"){
    panel.axis(side=side, draw.labels=T,outside=T, check.overlap = F,
               #                   labels=c("C>T","C>T","C>T","C>T","C>A","C>A","C>A","C>A","C>G","C>G","C>G","C>G"),
               labels = c("C>T","C>A","C>G"),
               rot=0, tck=0,at=c(10.5,6.5,2.5))
    panel.axis(side=side, outside=TRUE, at=c(4.5,8.5),  tck=3.5,draw.labels=F)
  }else{
    if(side == "left"){
      panel.axis(side=side,labels = c("G","A","C","T","G","A","C","T","G","A","C","T"),outside=T,draw.labels=T, check.overlap=F,
                 at=c(12,11,10,9,8,7,6,5,4,3,2,1))}             
    
    else axis.default(side=side, ...)
  } }

tables = list.files(path = ".", pattern = "norm_rec_1_*")
print(tables)

for (i in 1:1){
  name = "norm_int_-_rare_masha"#tables[i]
  print(name)
  outname = strsplit(name,"_for")[[1]][1]
  outname = paste("../../R_figure/",outname,".jpg",sep="")
  
  dano=read.table(name,header=T)
  dano = dano[2:ncol(dano)]
  dano = as.matrix(dano)
  dano = t(dano)
  jpeg(outname, res = 500, width = 5, height = 5, units = 'in')
 #   geom_segment(aes(x = 1, y = 4, xend = 4, yend = 4))
  rgb.palette <- colorRampPalette(c("darkblue", "white", "red"), space = "Lab")
 plot(levelplot(dano, xlab=NULL, ylab=NULL, axis=axis.set,col.regions = rgb.palette(1000), at=seq(-0.6, 0.6, length=1001),colorkey = list(space="left"),
                panel=function(...){
                  panel.levelplot(...) 
                  panel.abline(h=0.6,lwd=2.5,col = "green")
                  panel.abline(h=1.5, ,lwd=2.5,col = "green")
                  panel.abline(h=8.5, ,lwd=2.5,col = "green")
                  panel.abline(h=9.5, ,lwd=2.5,col = "green")
                  
                  
                  }
                ))

  dev.off()  
}