#require(ProCls)
setwd("/home/pamjat/Sonya");
require(ggplot2)
rt1<-read.table(file="results/cancer_cluster_assimetry.1",sep=" ");


sites=rep(1000000,20)
k<-riskscoreci((rt1$V3[1]), sites[1], (rt1$V4[1]), sites[1], conf.level=0.95)
lower_timing<-k$conf.int[1]
upper_timing<-k$conf.int[2]
for (x in 2:20) {k<-riskscoreci((rt1$V3[x]), sites[x], (rt1$V4[x]), sites[x], conf.level=0.95)
lower_timing<-c(lower_timing,k$conf.int[1])
upper_timing<-c(upper_timing,k$conf.int[2])
}
ggplot(rt1, aes(x=V1, y=V2))+geom_line(size=0.7)+ geom_pointrange(aes(ymin=lower_timing,ymax=upper_timing),position=position_dodge(.1),size=0.8)+
  xlab("Leading        <-        fp        ->        Lagging")+
  ylab("Strand asymmetry")+ scale_y_continuous(limits=c(0.12, 8),trans=log2_trans())+
  theme_bw()+
  theme( axis.title=element_text(size=15))+
  theme(title=element_text(size=12))+theme( axis.text.y=element_text(size=15),axis.text.x=element_text(size=0)) + 
  scale_color_manual(values=c("black", "grey"),
    name="",labels=c("",""))
# labels=c("APOrich, TCG->TKG", "APOpoor, TKW->TKW","APOrich, VCW->TKW","APOpoor, VCW->VKW"))

#  scale_color_manual(values=c("red", "blue"))+
#   theme(legend.title="Type of mutations")
# scale_color_discrete(name="Type of mutations",labels=c("TCW","VPC"))
