setwd("/home/pamjat/Sonya");
data<-read.table(file="results/apobec_pol_cont_fig",sep=" ")

coef1<-(1/data$V3[12])

conf_timing<-binconf( data$V4[1:12], data$V5[1:12])
lower_timing<-conf_timing[,2]*coef1
upper_timing<-conf_timing[,3]*coef1

ggplot(data,aes(x=V2,y=V3*coef1,fill=V1))+#geom_bar()
  geom_bar(colour="black",position=position_dodge(.9),stat="identity")+
  scale_fill_discrete(name="Mutation type")+#,values=c("#c1ffc1","#eed8ae")) + 
  ylab("normalized mutation frequency") + xlab('') +
  theme_bw()+
  theme( axis.title=element_text(size=15))+
  theme(title=element_text(size=12))+theme( axis.text.y=element_text(size=15),axis.text.x=element_text(size=15))+
  geom_errorbar(aes(ymin=lower_timing, ymax=upper_timing),position=position_dodge(.9), width=.2)+
  ggtitle("APOBEC in cancer")+#ggtitle(expression(r[apo]<2))+
  theme(legend.text = element_text(size = 14),legend.title = element_text( size=14, face="bold"))



