#require(ProCls)
setwd("/home/pamjat/Sonya");
require(ggplot2)
rt1<-read.table(file="results/apo_assim_rt_colapsed_bin_pol.NCA.G.1",sep=" ");


sites=rep(1000000,40)
k<-riskscoreci((rt1$V4[1]),( rt1$V6[1]/10), (rt1$V5[1]), (rt1$V7[1]/10), conf.level=0.95)
lower_timing<-k$conf.int[1]
upper_timing<-k$conf.int[2]
for (x in 2:40) {k<-riskscoreci((rt1$V4[x]), rt1$V6[x]/10, (rt1$V5[x]), rt1$V7[x]/10, conf.level=0.95)
lower_timing<-c(lower_timing,k$conf.int[1])
upper_timing<-c(upper_timing,k$conf.int[2])
}
ggplot(rt1, aes(x=V2, y=V3,color=V1))+geom_line(size=0.7)+ geom_pointrange(aes(ymin=lower_timing,ymax=upper_timing),position=position_dodge(.1),size=0.8)+
  xlab("Leading        <-        fp        ->        Lagging")+
  ylab("Strand asymmetry")+ scale_y_continuous(breaks = (8:13)*0.1,limits=c(0.8, 1.3),trans=log2_trans())+
  theme_bw()+
  theme( axis.title=element_text(size=15))+
  theme(title=element_text(size=12))+theme( axis.text.y=element_text(size=15),axis.text.x=element_text(size=0)) + 
  scale_color_manual(#values=c("black", "grey"),
    values=c("black","grey"), 
    name="",labels=c("", ""))
chisq.test(cbind(c(rt1$V4[1],rt1$V5[1]),c(rt1$V4[7],rt1$V5[7])))
# labels=c("APOrich, TCG->TKG", "APOpoor, TKW->TKW","APOrich, VCW->TKW","APOpoor, VCW->VKW"))

#  scale_color_manual(values=c("red", "blue"))+
#   theme(legend.title="Type of mutations")
# scale_color_discrete(name="Type of mutations",labels=c("TCW","VPC"))
