#require(ProCls)
setwd("/home/pamjat/Sonya");
require(ggplot2)
rt1<-read.table(file="results/apo_assim_rt_colapsed_bin_pol.NCT.T.5nuc",sep=" ");


sites=rep(1000000,80)
k<-riskscoreci((rt1$V4[1]), sites[1], (rt1$V5[1]), sites[1], conf.level=0.95)
lower_timing<-k$conf.int[1]
upper_timing<-k$conf.int[2]
for (x in 2:80) {k<-riskscoreci((rt1$V4[x]), sites[x], (rt1$V5[x]), sites[x], conf.level=0.95)
lower_timing<-c(lower_timing,k$conf.int[1])
upper_timing<-c(upper_timing,k$conf.int[2])
}
ggplot(rt1, aes(x=V2, y=V3,color=V1))+geom_line(size=0.7)+ geom_pointrange(aes(ymin=lower_timing,ymax=upper_timing),position=position_dodge(.1),size=0.8)+
  xlab("Leading        <-        fp        ->        Lagging")+
  ylab("Strand asymmetry")+ scale_y_continuous(breaks = (8:14)*0.1,limits=c(0.7, 1.5),trans=log2_trans())+
  theme_bw()+
  theme( axis.title=element_text(size=15))+
  theme(title=element_text(size=12))+theme( axis.text.y=element_text(size=15),axis.text.x=element_text(size=0)) + 
  theme(legend.position="none")+
   scale_color_manual(#values=c("black", "grey"),
    values=c("red","pink","black","grey") )
# labels=c("APOrich, TCG->TKG", "APOpoor, TKW->TKW","APOrich, VCW->TKW","APOpoor, VCW->VKW"))

#  scale_color_manual(values=c("red", "blue"))+
#   theme(legend.title="Type of mutations")
# scale_color_discrete(name="Type of mutations",labels=c("TCW","VPC"))

chisq.test(cbind(c(rt1$V4[1],rt1$V5[1]),c(rt1$V4[21],rt1$V5[21])))
           
