# SpliceHunter  #
### Alternative splicing detection and annotation from long read (time course) sequencing data ###

## Installing SpliceHunter ##

Before building SpliceHunter, make sure that the following libraries are installed on your system:

* SeqAn
* Boost
* BamTools

After cloning SpliceHunter, change to the newly created directory (default splicehunter) and use CMAKE (available at http://www.cmake.org) to build SpliceHunter.

```
cd splicehunter
mkdir build
cd build
cmake -DSEQAN_INCLUDE_PATH=<YOUR_SEQAN_INCLUDE_DIR> -DBAMTOOLS_ROOT=<YOUR_BAMTOOLS_DIR> ..
make
```

This will create binary SpliceHunter in directory `splicehunter/build/bin`.

## Running SpliceHunter ##

The following detailed description can also be obtained by typing 

```
SpliceHunter --help
```

### Usage ###

```
SpliceHunter [options] -g <anno> -f <ref> [-m <dir>]
```

### Main arguments ###

`-g <anno>`
:     The annotation in `gtf` format which is used as reference when defining alternative splicing events. 

`-f <ref>`
:     The reference sequence in `fasta` format

`-m <dir>`
:     Path to the directory containing aligned reads in `bam` format.


### Options ###

`-w <int>`
: splice site window

`-u <float>`
: ambiguity resolving threshold

`-d <int>`
: minimal overlap on different strand

`-o <int>`
: minimal overlap on same strand