#! /usr/bin/perl/

die "FASTA_File\tOutput\n" unless $#ARGV == 1;
my($input, $output) = @ARGV;

open(IN, "<$input") or die "Can't open $input for reading!\n";
open(OUT, ">$output") or die "Can't open $output for writing!\n";

while($line = <IN>) {
	chomp($line);
	if($line =~ ">") {
		print OUT $line,"\n";
	} else {
		$line = uc $line;
	        $rcline = reverse $line;
        	$rcline =~ tr/ACGTacgt/TGCAtgca/;
	        @array = split(//, $line);
		@MOTIF = ();
		for($x = 0; $x <= $#array; $x++) {
			push(@MOTIF, {nuc => $array[$x], order => rand, orig => $x});
		}
		@FINAL = sort { $$a{'order'} <=> $$b{'order'} } @MOTIF;
		for($x = 0; $x <= $#FINAL; $x++) {
			print OUT $FINAL[$x]{'nuc'};
#			print $FINAL[$x]{'order'},"\t",$FINAL[$x]{'orig'},"\n";
		}
		print OUT "\n";
#		exit;
	}
}

close IN;
close OUT;
