/*
 * Decompiled with CFR 0.152.
 */
package tree;

import helper.IOHelp;
import java.util.ArrayList;
import simulation.Site;
import structure.Anchor;
import structure.GenomicRegion;

public class Cluster
extends GenomicRegion {
    private static int CLUSTER_COUNT = 0;
    private final int id;
    private Cluster parent;
    private final ArrayList<Cluster> children;
    private int level;
    private final Site site;
    private final Anchor anchor;

    public Cluster(Anchor anchor) {
        super(anchor.getChromosomeName(), anchor.getGenomicStart(), anchor.getGenomicEnd());
        this.anchor = anchor;
        anchor.setCluster(this);
        this.parent = null;
        this.children = new ArrayList();
        this.level = -1;
        this.site = new Site(this);
        this.id = CLUSTER_COUNT++;
    }

    public Cluster(String chromosomeName, int genomicStart, int genomicEnd) {
        super(chromosomeName, genomicStart, genomicEnd);
        this.parent = null;
        this.anchor = null;
        this.children = new ArrayList();
        this.level = -1;
        this.site = new Site(this);
        this.id = CLUSTER_COUNT++;
    }

    public Site getSite() {
        return this.site;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public int getID() {
        return this.id;
    }

    public static int totalClusters() {
        return CLUSTER_COUNT;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public Cluster getParent() {
        return this.parent;
    }

    public void setParent(Cluster cluster) {
        this.parent = cluster;
    }

    public ArrayList<Cluster> getChildren() {
        return this.children;
    }

    public Cluster getChild(int i) {
        return this.children.get(i);
    }

    public void addChild(Cluster child) {
        if (!this.children.contains(child)) {
            int index;
            int childPos = child.getGenomicPosition();
            for (index = 0; index < this.children.size() && childPos > this.children.get(index).getGenomicPosition(); ++index) {
            }
            this.children.add(index, child);
        }
    }

    public void clearChildren() {
        this.children.clear();
    }

    public int getChildrenNumber() {
        return this.children.size();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public String printCluster() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGenomicPosition()).append(" ");
        sb.append(this.getGenomicStart()).append(" ");
        sb.append(this.getGenomicEnd()).append(" ");
        sb.append(IOHelp.DF[6].format(this.site.getX())).append(" ");
        sb.append(IOHelp.DF[6].format(this.site.getY())).append(" ");
        sb.append(IOHelp.DF[6].format(this.site.getZ())).append(" ");
        sb.append(this.children.size()).append(" ");
        for (Cluster child : this.children) {
            sb.append(child.getID()).append(" ");
        }
        return sb.toString();
    }
}

